/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTypeUsageCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(0);
        }
        HashSet<String> facets = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet2 : FacetManager.getInstance((Module)module).getAllFacets()) {
                facets.add(facet2.getType().getStringId());
            }
        }
        Set set = ContainerUtil.map2Set(facets, facet -> new UsageDescriptor((String)facet, 1));
        if (set == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("module.facets" == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(2);
        }
        return "module.facets";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FacetTypeUtilValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "facets_type".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(1);
            }
            if (FacetTypeUtilValidator.isThirdPartyValue(data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    FacetTypeUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            FacetType facet = FacetTypeUtilValidator.findFacetById(data);
            if (facet == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    FacetTypeUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(facet.getClass());
            if (StringUtil.equals((CharSequence)data, (CharSequence)context.eventId)) {
                context.setPluginInfo(info);
            }
            ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        @Nullable
        private static FacetType findFacetById(@NotNull String data) {
            FacetType[] facets;
            if (data == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(5);
            }
            for (FacetType facet : facets = (FacetType[])FacetType.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)facet.getStringId(), (CharSequence)data)) continue;
                return facet;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector$FacetTypeUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector$FacetTypeUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findFacetById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

