/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboPopup;

public class DarculaPopupMenuBorder
extends AbstractBorder
implements UIResource {
    private static final JBInsets DEFAULT_INSETS = JBUI.insets((int)1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor((Color)JBColor.namedColor((String)"Menu.borderColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51)));
            g2.fill(DarculaPopupMenuBorder.getBorderShape(c2, new Rectangle(x, y, width, height)));
        }
        finally {
            g2.dispose();
        }
    }

    private static Shape getBorderShape(Component c2, Rectangle rect) {
        Path2D.Float border = new Path2D.Float(0);
        if (DarculaPopupMenuBorder.isComboPopup(c2) && ((BasicComboPopup)c2).getClientProperty("JComboBox.isCellEditor") == Boolean.TRUE) {
            JBInsets.removeFrom((Rectangle)rect, (Insets)JBInsets.create((int)0, (int)1));
        }
        border.append(rect, false);
        Rectangle innerRect = new Rectangle(rect);
        JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)JBUI.getInt((String)"PopupMenu.borderWidth", (int)1)));
        border.append(innerRect, false);
        return border;
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        if (DarculaPopupMenuBorder.isComboPopup(c2)) {
            return JBInsets.create((int)1, (int)2).asUIResource();
        }
        return JBUI.insets((String)"PopupMenu.borderInsets", (JBInsets)DEFAULT_INSETS).asUIResource();
    }

    protected static boolean isComboPopup(Component c2) {
        return "ComboPopup.popup".equals(c2.getName()) && c2 instanceof BasicComboPopup;
    }
}

