/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c2) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config2 = new GraphicsConfig((Graphics)g);
        Color bg = c2.getBackground();
        g.setPaint(bg);
        int h = c2.getHeight();
        int w = c2.getWidth();
        g.fillRect(0, 0, w, h);
        JBColor bottomSeparatorColor = JBColor.namedColor((String)"TableHeader.bottomSeparatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.75));
        g.setPaint((Paint)bottomSeparatorColor);
        UIUtil.drawLine((Graphics)g, (int)0, (int)(h - 1), (int)w, (int)(h - 1));
        Enumeration<TableColumn> columns = ((JTableHeader)c2).getColumnModel().getColumns();
        JBColor lineColor = JBColor.namedColor((String)"TableHeader.separatorColor", (Color)ColorUtil.shift((Color)bg, (double)0.7));
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!columns.hasMoreElements() || column.getWidth() <= 0) continue;
            g.setColor((Color)lineColor);
            UIUtil.drawLine((Graphics)g, (int)((offset += column.getWidth()) - 1), (int)1, (int)(offset - 1), (int)(h - 3));
        }
        config2.restore();
        super.paint(g, c2);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = super.getPreferredSize(c2);
        if (size.height == 0) {
            return size;
        }
        JBValue.UIInteger height = new JBValue.UIInteger("TableHeader.height", 25);
        return new Dimension(size.width, Math.max(height.get(), size.height));
    }
}

