/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    public static final String DIFF_TITLE_RENAME_SEPARATOR = " -> ";
    private final DiffContentFactoryEx myContentFactory = DiffContentFactoryEx.getInstanceEx();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        assert (file1 != null || file2 != null);
        EmptyContent content1 = file1 != null ? this.myContentFactory.create(project, file1) : this.myContentFactory.createEmpty();
        EmptyContent content2 = file2 != null ? this.myContentFactory.create(project, file2) : this.myContentFactory.createEmpty();
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitle(file1, file2);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
        if (simpleDiffRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(0);
        }
        return simpleDiffRequest;
    }

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        if (leftFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(1);
        }
        if (baseFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(2);
        }
        if (rightFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(3);
        }
        DiffContent content1 = this.myContentFactory.create(project, leftFile);
        DiffContent content2 = this.myContentFactory.create(project, baseFile);
        DiffContent content3 = this.myContentFactory.create(project, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
        if (simpleDiffRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(4);
        }
        return simpleDiffRequest;
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value) {
        if (value == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(5);
        }
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(title, content1, (DiffContent)content2, title1, title2);
        if (simpleDiffRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(6);
        }
        return simpleDiffRequest;
    }

    @Nullable
    public String getContentTitle(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return DiffRequestFactoryImpl.getContentTitle(VcsUtil.getFilePath((VirtualFile)file2));
    }

    @NotNull
    public String getTitle(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        FilePath path1 = file1 != null ? VcsUtil.getFilePath((VirtualFile)file1) : null;
        FilePath path2 = file2 != null ? VcsUtil.getFilePath((VirtualFile)file2) : null;
        String string = DiffRequestFactoryImpl.getTitle(path1, path2, " vs ");
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(8);
        }
        String string = this.getTitle(file2, null);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getContentTitle(@NotNull FilePath path) {
        if (path == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(10);
        }
        if (path.isDirectory()) {
            String string = path.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        FilePath parent = path.getParentPath();
        String string = DiffRequestFactoryImpl.getContentTitle(path.getName(), path.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getTitle(@Nullable FilePath path1, @Nullable FilePath path2, @NotNull String separator) {
        if (separator == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(13);
        }
        assert (path1 != null || path2 != null);
        if (path1 == null || path2 == null) {
            String string = DiffRequestFactoryImpl.getContentTitle((FilePath)ObjectUtils.chooseNotNull((Object)path1, (Object)path2));
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            String string = path1.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(15);
            }
            return string;
        }
        String name1 = path1.getName();
        String name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        String string = DiffRequestFactoryImpl.getRequestTitle(name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getContentTitle(@NotNull String name, @NotNull String path, @Nullable String parentPath) {
        if (name == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(17);
        }
        if (path == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(18);
        }
        if (parentPath != null) {
            String string = name + " (" + parentPath + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String getRequestTitle(@NotNull String name1, @NotNull String path1, @Nullable String parentPath1, @NotNull String name2, @NotNull String path2, @Nullable String parentPath2, @NotNull String sep) {
        if (name1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(21);
        }
        if (path1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(22);
        }
        if (name2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(23);
        }
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(24);
        }
        if (sep == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(25);
        }
        if (path1.equals(path2)) {
            String string = DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(26);
            }
            return string;
        }
        if (Comparing.equal((String)parentPath1, (String)parentPath2)) {
            if (parentPath1 != null) {
                String string = name1 + sep + name2 + " (" + parentPath1 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(27);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(28);
            }
            return string;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                String string = name1 + " (" + parentPath1 + sep + parentPath2 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(29);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(30);
            }
            return string;
        }
        if (parentPath1 != null && parentPath2 != null) {
            String string = name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = path1 + sep + path2;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @Nullable String title, @NotNull List<String> titles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (outputDocument == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(33);
        }
        if (textContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(34);
        }
        if (titles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(35);
        }
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text2 : textContents) {
            contents.add(this.myContentFactory.create(project, text2, fileType));
        }
        TextMergeRequestImpl request = new TextMergeRequestImpl(project, outputContent, originalContent, contents, title, titles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(36);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(37);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(38);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(39);
        }
        MergeRequest request = this.createMergeRequest(project, output, byteContents, title, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(40);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(41);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(42);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(43);
        }
        try {
            textMergeRequest = this.createTextMergeRequest(project, output, byteContents, title, contentTitles);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequest(project, output, byteContents, title, contentTitles);
            if (mergeRequest == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(45);
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(44);
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(46);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(47);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(48);
        }
        TextMergeRequest request = this.createTextMergeRequest(project, output, byteContents, title, contentTitles);
        TextMergeRequest textMergeRequest = (TextMergeRequest)MergeCallback.register((MergeRequest)request, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(49);
        }
        return textMergeRequest;
    }

    @NotNull
    private TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(50);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(51);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(52);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = FileDocumentManager.getInstance().getDocument(output);
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (byte[] bytes : byteContents) {
            contents.add(this.myContentFactory.createDocumentFromBytes(project, bytes, output));
        }
        TextMergeRequestImpl textMergeRequestImpl = new TextMergeRequestImpl(project, outputContent, originalContent, contents, title, contentTitles);
        if (textMergeRequestImpl == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(53);
        }
        return textMergeRequestImpl;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(54);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(55);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(56);
        }
        MergeRequest request = this.createBinaryMergeRequest(project, output, byteContents, title, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(57);
        }
        return mergeRequest;
    }

    @NotNull
    private MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) throws InvalidDiffRequestException {
        BinaryMergeRequestImpl binaryMergeRequestImpl;
        block9: {
            if (output == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(58);
            }
            if (byteContents == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(59);
            }
            if (contentTitles == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(60);
            }
            if (byteContents.size() != 3) {
                throw new IllegalArgumentException();
            }
            if (contentTitles.size() != 3) {
                throw new IllegalArgumentException();
            }
            try {
                FileContent outputContent = this.myContentFactory.createFile(project, output);
                if (outputContent == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + output);
                }
                byte[] originalContent = output.contentsToByteArray();
                ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
                for (byte[] bytes : byteContents) {
                    contents.add(this.myContentFactory.createFromBytes(project, bytes, output));
                }
                binaryMergeRequestImpl = new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title, contentTitles);
                if (binaryMergeRequestImpl != null) break block9;
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
            }
            DiffRequestFactoryImpl.$$$reportNull$$$0(61);
        }
        return binaryMergeRequestImpl;
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(62);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(63);
        }
        String title = "Merge " + output.getPresentableUrl();
        List<String> titles = Arrays.asList("Your Version", "Base Version", "Their Version");
        MergeRequest mergeRequest = this.createMergeRequestFromFiles(project, output, fileContents, title, titles, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(64);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(65);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(66);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(67);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            textMergeRequest = this.createTextMergeRequestFromFiles(project, output, fileContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequestFromFiles(project, output, fileContents, title, contentTitles, applyCallback);
            if (mergeRequest == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(69);
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(68);
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(70);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(71);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(72);
        }
        ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
        for (VirtualFile virtualFile : fileContents) {
            try {
                byteContents.add(virtualFile.contentsToByteArray());
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file: " + virtualFile.getPresentableUrl(), (Throwable)e);
            }
        }
        TextMergeRequest textMergeRequest = this.createTextMergeRequest(project, output, byteContents, title, contentTitles, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(73);
        }
        return textMergeRequest;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        MergeRequest mergeRequest;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(74);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(75);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(76);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output.getPresentableUrl());
            }
            byte[] originalContent = output.contentsToByteArray();
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
            for (VirtualFile virtualFile : fileContents) {
                FileContent content2 = this.myContentFactory.createFile(project, virtualFile);
                if (content2 == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + virtualFile.getPresentableUrl());
                }
                contents.add((DiffContent)content2);
                byteContents.add(virtualFile.contentsToByteArray());
            }
            BinaryMergeRequestImpl request = new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title, contentTitles);
            mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(77);
        }
        return mergeRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDocument";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textContents";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 37: 
            case 41: 
            case 46: 
            case 50: 
            case 54: 
            case 58: 
            case 62: 
            case 65: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 38: 
            case 42: 
            case 47: 
            case 51: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 39: 
            case 43: 
            case 48: 
            case 52: 
            case 56: 
            case 60: 
            case 67: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 63: 
            case 66: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createClipboardVsValue";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitle";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestTitle";
                break;
            }
            case 36: 
            case 40: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequest";
                break;
            }
            case 49: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequest";
                break;
            }
            case 57: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequest";
                break;
            }
            case 64: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequestFromFiles";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequestFromFiles";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFromFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createClipboardVsValue";
                break;
            }
            case 8: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 10: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContentTitle";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRequestTitle";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequest";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequest";
                break;
            }
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequestFromFiles";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequestFromFiles";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

