/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.histogram;

import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.util.HeapReportUtils;
import com.intellij.diagnostic.hprof.util.TruncatingPrintBuffer;
import com.intellij.diagnostic.hprof.visitors.HistogramVisitor;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "", "entries", "", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "instanceCount", "", "(Ljava/util/List;J)V", "getEntries", "()Ljava/util/List;", "getInstanceCount", "()J", "getTotals", "Lkotlin/Pair;", "prepareReport", "", "name", "topClassCount", "", "Companion", "intellij.platform.ide.impl"})
public final class Histogram {
    @NotNull
    private final List<HistogramEntry> entries;
    private final long instanceCount;
    public static final Companion Companion = new Companion(null);

    private final Pair<Long, Long> getTotals() {
        long totalInstances = 0L;
        long totalBytes = 0L;
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistogramEntry it = (HistogramEntry)element$iv;
            boolean bl = false;
            totalBytes += it.getTotalBytes();
            totalInstances += it.getTotalInstances();
        }
        return new Pair((Object)totalInstances, (Object)totalBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareReport(@NotNull String name, int topClassCount) {
        Object buffer2;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        StringBuilder result2 = new StringBuilder();
        Function1 appendToResult2 = (Function1)new Function1<String, Unit>(result2){
            final /* synthetic */ StringBuilder $result;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                StringBuilder stringBuilder = this.$result;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(s);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
            }
            {
                this.$result = stringBuilder;
                super(1);
            }
        };
        int counter = 1;
        Object object = new TruncatingPrintBuffer(topClassCount, 2, (Function1<? super String, ? extends Object>)appendToResult2);
        boolean bl = false;
        Throwable throwable = null;
        try {
            buffer2 = (TruncatingPrintBuffer)object;
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry entry = (HistogramEntry)element$iv;
                boolean bl3 = false;
                ((TruncatingPrintBuffer)buffer2).println(Histogram.Companion.formatEntryLine(counter, entry));
                int n = counter;
                counter = n + 1;
            }
            Histogram.Companion.printSummary((TruncatingPrintBuffer)buffer2, this, name);
            buffer2 = Unit.INSTANCE;
        }
        catch (Throwable buffer2) {
            throwable = buffer2;
            throw buffer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        StringsKt.appendln((StringBuilder)result2);
        object = result2;
        String string = "Top 10 by bytes count:";
        int n = 0;
        StringBuilder stringBuilder = ((StringBuilder)object).append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        Iterable $this$sortedByDescending$iv22 = this.entries;
        boolean $i$f$sortedByDescending = false;
        buffer2 = $this$sortedByDescending$iv22;
        boolean bl4 = false;
        Object object2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalBytes();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List entriesByBytes = CollectionsKt.sortedWith((Iterable)buffer2, (Comparator)object2);
        int $this$sortedByDescending$iv22 = 0;
        n = 10;
        while ($this$sortedByDescending$iv22 < n) {
            void i;
            HistogramEntry entry = (HistogramEntry)entriesByBytes.get((int)i);
            StringBuilder stringBuilder2 = result2;
            object2 = Histogram.Companion.formatEntryLine((int)(i + true), entry);
            boolean bl5 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            ++i;
        }
        String string2 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    @NotNull
    public final List<HistogramEntry> getEntries() {
        return this.entries;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    public Histogram(@NotNull List<HistogramEntry> entries, long instanceCount) {
        Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
        this.entries = entries;
        this.instanceCount = instanceCount;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J.\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\fJ \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\nH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diagnostic/hprof/histogram/Histogram$Companion;", "", "()V", "create", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "formatEntryLine", "", "counter", "", "entry", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "formatEntryLineMerged", "entry2", "prepareMergedHistogramReport", "mainHistogram", "mainHistogramName", "secondaryHistogram", "secondaryHistogramName", "topClassCount", "printSummary", "", "buffer", "Lcom/intellij/diagnostic/hprof/util/TruncatingPrintBuffer;", "histogram", "histogramName", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Histogram create(@NotNull HProfEventBasedParser parser, @NotNull ClassStore classStore) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
            HistogramVisitor histogramVisitor = new HistogramVisitor(classStore);
            parser.accept(histogramVisitor, "histogram");
            return histogramVisitor.createHistogram();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String prepareMergedHistogramReport(@NotNull Histogram mainHistogram, @NotNull String mainHistogramName, @NotNull Histogram secondaryHistogram, @NotNull String secondaryHistogramName, int topClassCount) {
            boolean bl;
            Object buffer2;
            Intrinsics.checkParameterIsNotNull((Object)mainHistogram, (String)"mainHistogram");
            Intrinsics.checkParameterIsNotNull((Object)mainHistogramName, (String)"mainHistogramName");
            Intrinsics.checkParameterIsNotNull((Object)secondaryHistogram, (String)"secondaryHistogram");
            Intrinsics.checkParameterIsNotNull((Object)secondaryHistogramName, (String)"secondaryHistogramName");
            StringBuilder result2 = new StringBuilder();
            Function1 appendToResult2 = (Function1)new Function1<String, Unit>(result2){
                final /* synthetic */ StringBuilder $result;

                public final void invoke(@NotNull String s) {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    StringBuilder stringBuilder = this.$result;
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append(s);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                }
                {
                    this.$result = stringBuilder;
                    super(1);
                }
            };
            int counter = 1;
            HashMap mapClassNameToEntrySecondary = new HashMap();
            Object $this$forEach$iv = secondaryHistogram.getEntries();
            boolean $i$f$forEach22 = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                HistogramEntry it = (HistogramEntry)element$iv;
                boolean bl2 = false;
                ((Map)mapClassNameToEntrySecondary).put(it.getClassDefinition().getName(), it);
            }
            $this$forEach$iv = new TruncatingPrintBuffer(topClassCount, 2, (Function1<? super String, ? extends Object>)appendToResult2);
            $i$f$forEach22 = false;
            object = null;
            try {
                buffer2 = (TruncatingPrintBuffer)$this$forEach$iv;
                bl = false;
                Iterable $this$forEach$iv2 = mainHistogram.getEntries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    HistogramEntry entry = (HistogramEntry)element$iv;
                    boolean bl3 = false;
                    HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                    ((TruncatingPrintBuffer)buffer2).println(Companion.formatEntryLineMerged(counter, entry, entry2));
                    int n = counter;
                    counter = n + 1;
                }
                Companion.printSummary((TruncatingPrintBuffer)buffer2, mainHistogram, mainHistogramName);
                Companion.printSummary((TruncatingPrintBuffer)buffer2, secondaryHistogram, secondaryHistogramName);
                buffer2 = Unit.INSTANCE;
            }
            catch (Throwable buffer2) {
                object = buffer2;
                throw buffer2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object);
            }
            StringsKt.appendln((StringBuilder)result2);
            $this$forEach$iv = result2;
            String $i$f$forEach22 = "Top 10 by bytes count:";
            int n = 0;
            StringBuilder stringBuilder = ((StringBuilder)$this$forEach$iv).append($i$f$forEach22);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            Iterable $this$sortedByDescending$iv22 = mainHistogram.getEntries();
            boolean $i$f$sortedByDescending = false;
            buffer2 = $this$sortedByDescending$iv22;
            bl = false;
            Object object2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    HistogramEntry it = (HistogramEntry)b;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getTotalBytes());
                    it = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = it.getTotalBytes();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
            List entriesByBytes = CollectionsKt.sortedWith((Iterable)buffer2, (Comparator)object2);
            int $this$sortedByDescending$iv22 = 0;
            n = 10;
            while ($this$sortedByDescending$iv22 < n) {
                void i;
                HistogramEntry entry = (HistogramEntry)entriesByBytes.get((int)i);
                HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                object2 = result2;
                String string = this.formatEntryLineMerged((int)(i + true), entry, entry2);
                boolean bl4 = false;
                StringBuilder stringBuilder2 = ((StringBuilder)object2).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                ++i;
            }
            String string = result2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void printSummary(TruncatingPrintBuffer buffer, Histogram histogram, String histogramName) {
            void totalInstances;
            Pair pair = histogram.getTotals();
            long l = ((Number)pair.component1()).longValue();
            long totalBytes = ((Number)pair.component2()).longValue();
            pair = StringCompanionObject.INSTANCE;
            String string = "Total - %10s: %s %s %d classes (Total instances: %d)";
            Object[] objectArray = new Object[]{histogramName, HeapReportUtils.Companion.toPaddedShortStringAsCount((long)totalInstances), HeapReportUtils.Companion.toPaddedShortStringAsSize(totalBytes), histogram.getEntries().size(), histogram.getInstanceCount()};
            TruncatingPrintBuffer truncatingPrintBuffer = buffer;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            truncatingPrintBuffer.println(string3);
        }

        private final String formatEntryLineMerged(int counter, HistogramEntry entry, HistogramEntry entry2) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%5d: [%s/%s] [%s/%s] %s";
            Object[] objectArray = new Object[6];
            objectArray[0] = counter;
            objectArray[1] = HeapReportUtils.Companion.toPaddedShortStringAsCount(entry.getTotalInstances());
            objectArray[2] = HeapReportUtils.Companion.toPaddedShortStringAsSize(entry.getTotalBytes());
            HistogramEntry histogramEntry = entry2;
            objectArray[3] = HeapReportUtils.Companion.toPaddedShortStringAsCount(histogramEntry != null ? histogramEntry.getTotalInstances() : 0L);
            HistogramEntry histogramEntry2 = entry2;
            objectArray[4] = HeapReportUtils.Companion.toPaddedShortStringAsSize(histogramEntry2 != null ? histogramEntry2.getTotalBytes() : 0L);
            objectArray[5] = entry.getClassDefinition().getPrettyName();
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final String formatEntryLine(int counter, HistogramEntry entry) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%5d: [%s/%s] %s";
            Object[] objectArray = new Object[]{counter, HeapReportUtils.Companion.toPaddedShortStringAsCount(entry.getTotalInstances()), HeapReportUtils.Companion.toPaddedShortStringAsSize(entry.getTotalBytes()), entry.getClassDefinition().getPrettyName()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

