/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

class AnalyzerProgressIndicator
extends EmptyProgressIndicator {
    private long myStartMillis = System.currentTimeMillis();
    private DateFormat myFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);

    AnalyzerProgressIndicator() {
        super(ModalityState.NON_MODAL);
        this.myFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setText(String text2) {
        super.setText(text2);
        this.print(text2);
    }

    public void setText2(String text2) {
        super.setText2(text2);
        this.print("  " + text2);
    }

    private void print(String text2) {
        long elapsedMs = System.currentTimeMillis() - this.myStartMillis;
        if (elapsedMs < 0L) {
            elapsedMs = 0L;
        }
        System.out.printf("[%s] %s...%n", this.myFormat.format(elapsedMs), text2);
    }
}

