/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.protege.editor.core.ui.about.PluginInfoTable;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.update.PluginManager;

public class PluginPreferencesPanel
extends PreferencesPanel {
    private JCheckBox checkForUpdatesAtStartupCheckBox;
    private JTextField pluginRegistryEditor;

    @Override
    public void applyChanges() {
        PluginManager.getInstance().setAutoUpdateEnabled(this.checkForUpdatesAtStartupCheckBox.isSelected());
        try {
            URL url = new URL(this.pluginRegistryEditor.getText());
            PluginManager.getInstance().setPluginRegistryLocation(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dispose() throws Exception {
    }

    @Override
    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.add((Component)panel, "North");
        panel.addGroup("Auto update");
        this.checkForUpdatesAtStartupCheckBox = new JCheckBox("Automatically check for plugin updates at start up", PluginManager.getInstance().isAutoUpdateEnabled());
        panel.addGroupComponent(this.checkForUpdatesAtStartupCheckBox);
        panel.addSeparator();
        panel.addGroup("Plugin registry");
        this.pluginRegistryEditor = new JTextField(PluginManager.getInstance().getPluginRegistryLocation().toString(), 50);
        panel.addGroupComponent(this.pluginRegistryEditor);
        panel.addHelpText("This is the location that Prot\u00e9g\u00e9 will use to check which plugins are available");
        JButton resetToDefaultRegistry = new JButton("Reset to default registry location");
        resetToDefaultRegistry.addActionListener(e -> this.pluginRegistryEditor.setText("https://raw.githubusercontent.com/protegeproject/autoupdate/master/update-info/5.0.0/plugins.repository"));
        panel.addIndentedGroupComponent(resetToDefaultRegistry);
        panel.addSeparator();
        panel.addGroup("Installed plugins");
        JScrollPane pluginInfoScrollPane = new JScrollPane(new PluginInfoTable());
        pluginInfoScrollPane.setPreferredSize(new Dimension(500, 300));
        panel.addGroupComponent(pluginInfoScrollPane);
    }
}

