/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.pdfsam.context.StringUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableFileField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceSetterOnValidState
implements ChangeListener<FXValidationSupport.ValidationState> {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceBrowsableFileField.class);
    private StringUserPreference preference;
    private ValidableTextField textField;
    private UserContext userContext;

    PreferenceSetterOnValidState(StringUserPreference preference, ValidableTextField textField, UserContext userContext) {
        RequireUtils.requireNotNull((Object)preference, (String)"Preference cannot be null");
        RequireUtils.requireNotNull((Object)textField, (String)"TextField cannot be null");
        this.textField = textField;
        this.preference = preference;
        this.userContext = userContext;
    }

    public void changed(ObservableValue<? extends FXValidationSupport.ValidationState> observable, FXValidationSupport.ValidationState oldValue, FXValidationSupport.ValidationState newValue) {
        if (newValue == FXValidationSupport.ValidationState.VALID) {
            this.userContext.setStringPreference(this.preference, this.textField.getText());
            LOG.trace("Preference {} set to {}", (Object)this.preference, (Object)this.textField.getText());
        }
    }
}

