/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.validation.constraint.NotEmpty;

public class SplitByPagesParameters
extends AbstractSplitByPageParameters {
    @NotEmpty
    private final Set<Integer> pages = new NullSafeSet<Integer>();

    public void addPages(Collection<Integer> pagesToAdd) {
        this.pages.addAll(pagesToAdd);
    }

    public void addPage(Integer page) {
        this.pages.add(page);
    }

    @Override
    public Set<Integer> getPages(int upperLimit) {
        return Collections.unmodifiableSet(this.pages.stream().filter(p -> p <= upperLimit && p > 0).collect(Collectors.toSet()));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(this.pages).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.pages).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitByPagesParameters)) {
            return false;
        }
        SplitByPagesParameters parameter = (SplitByPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.pages, parameter.pages).isEquals();
    }
}

