/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.notification.dsl;

import java.math.BigDecimal;
import org.sejda.core.notification.context.GlobalNotificationContext;
import org.sejda.core.notification.context.ThreadLocalNotificationContext;
import org.sejda.core.notification.dsl.Notifier;
import org.sejda.core.notification.dsl.OngoingNotification;
import org.sejda.model.notification.event.AbstractNotificationEvent;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionStartedEvent;
import org.sejda.model.notification.event.TaskExecutionWarningEvent;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationEventsNotifier
implements Notifier,
OngoingNotification {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationEventsNotifier.class);
    private BigDecimal percentage = BigDecimal.ZERO;
    private NotifiableTaskMetadata taskMetadata;

    private ApplicationEventsNotifier(NotifiableTaskMetadata taskMetadata) {
        this.taskMetadata = taskMetadata;
    }

    public static Notifier notifyEvent(NotifiableTaskMetadata taskMetadata) {
        return new ApplicationEventsNotifier(taskMetadata);
    }

    @Override
    public void taskFailed(Exception e) {
        this.notifyListeners((AbstractNotificationEvent)new TaskExecutionFailedEvent(e, this.taskMetadata));
    }

    @Override
    public void taskCompleted(long executionTime) {
        this.notifyListeners((AbstractNotificationEvent)new TaskExecutionCompletedEvent(executionTime, this.taskMetadata));
    }

    @Override
    public void taskStarted() {
        this.notifyListeners((AbstractNotificationEvent)new TaskExecutionStartedEvent(this.taskMetadata));
    }

    @Override
    public void taskWarning(String warning) {
        LOG.warn(warning);
        this.notifyListeners((AbstractNotificationEvent)new TaskExecutionWarningEvent(warning, this.taskMetadata));
    }

    @Override
    public void taskWarning(String warning, Exception e) {
        LOG.warn(warning, (Throwable)e);
        this.notifyListeners((AbstractNotificationEvent)new TaskExecutionWarningEvent(warning, this.taskMetadata));
    }

    @Override
    public void progressUndetermined() {
        this.notifyListeners((AbstractNotificationEvent)new PercentageOfWorkDoneChangedEvent(PercentageOfWorkDoneChangedEvent.UNDETERMINED, this.taskMetadata));
    }

    @Override
    public OngoingNotification stepsCompleted(int completed) {
        this.percentage = new BigDecimal(completed);
        return this;
    }

    @Override
    public OngoingNotification stepsCompleted(BigDecimal completed) {
        this.percentage = completed;
        return this;
    }

    @Override
    public void outOf(int total) {
        this.outOf(new BigDecimal(total));
    }

    @Override
    public void outOf(BigDecimal total) {
        this.notifyListeners((AbstractNotificationEvent)new PercentageOfWorkDoneChangedEvent(this.percentage.multiply(PercentageOfWorkDoneChangedEvent.MAX_PERGENTAGE).divide(total, 5), this.taskMetadata));
    }

    private void notifyListeners(AbstractNotificationEvent event) {
        LOG.trace("Notifing event {}", (Object)event);
        GlobalNotificationContext.getContext().notifyListeners(event);
        ThreadLocalNotificationContext.getContext().notifyListeners(event);
    }
}

