/*
 * Copyright 2012-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.cli.compiler.dependencies;

import java.io.IOException;

import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.locator.DefaultModelLocator;

/**
 * {@link DependencyManagement} derived from the effective pom of
 * {@code spring-boot-dependencies}.
 *
 * @author Andy Wilkinson
 * @since 1.3.0
 */
public class SpringBootDependenciesDependencyManagement extends MavenModelDependencyManagement {

	public SpringBootDependenciesDependencyManagement() {
		super(readModel());
	}

	private static Model readModel() {
		DefaultModelProcessor modelProcessor = new DefaultModelProcessor();
		modelProcessor.setModelLocator(new DefaultModelLocator());
		modelProcessor.setModelReader(new DefaultModelReader());

		try {
			return modelProcessor.read(
					SpringBootDependenciesDependencyManagement.class.getResourceAsStream("effective-pom.xml"), null);
		}
		catch (IOException ex) {
			throw new IllegalStateException("Failed to build model from effective pom", ex);
		}
	}

}
