/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.events.task.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTaskDescriptor;
import org.gradle.tooling.model.internal.Exceptions;

public final class DefaultTaskOperationDescriptor
extends DefaultOperationDescriptor
implements TaskOperationDescriptor {
    private static final String DEPENDENCIES_METHOD = TaskOperationDescriptor.class.getSimpleName() + ".getDependencies()";
    private static final String ORIGIN_PLUGIN_METHOD = TaskOperationDescriptor.class.getSimpleName() + ".getOriginPlugin()";
    private final String taskPath;
    private final Supplier<Set<OperationDescriptor>> dependencies;
    private final Supplier<PluginIdentifier> originPlugin;

    public DefaultTaskOperationDescriptor(InternalTaskDescriptor descriptor, OperationDescriptor parent, String taskPath) {
        super(descriptor, parent);
        this.taskPath = taskPath;
        this.dependencies = DefaultTaskOperationDescriptor.unsupportedMethodExceptionThrowingSupplier(DEPENDENCIES_METHOD);
        this.originPlugin = DefaultTaskOperationDescriptor.unsupportedMethodExceptionThrowingSupplier(ORIGIN_PLUGIN_METHOD);
    }

    public DefaultTaskOperationDescriptor(InternalTaskDescriptor descriptor, OperationDescriptor parent, String taskPath, Set<OperationDescriptor> dependencies, @Nullable PluginIdentifier originPlugin) {
        super(descriptor, parent);
        this.taskPath = taskPath;
        this.dependencies = Suppliers.ofInstance(dependencies);
        this.originPlugin = Suppliers.ofInstance((Object)originPlugin);
    }

    @Override
    public String getTaskPath() {
        return this.taskPath;
    }

    @Override
    public Set<? extends OperationDescriptor> getDependencies() {
        return (Set)this.dependencies.get();
    }

    @Override
    @Nullable
    public PluginIdentifier getOriginPlugin() {
        return (PluginIdentifier)this.originPlugin.get();
    }

    private static <T> Supplier<T> unsupportedMethodExceptionThrowingSupplier(final String method) {
        return new Supplier<T>(){

            public T get() {
                throw Exceptions.unsupportedMethod(method);
            }
        };
    }
}

