/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks;

import groovy.lang.Closure;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.CustomManifestInternalWrapper;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.ConfigureUtil;

public class Jar
extends Zip {
    public static final String DEFAULT_EXTENSION = "jar";
    private String manifestContentCharset = "UTF-8";
    private Manifest manifest;
    private final CopySpecInternal metaInf;

    public Jar() {
        this.getArchiveExtension().set((Object)DEFAULT_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.manifest = new DefaultManifest((PathToFileResolver)this.getFileResolver());
        this.metaInf = (CopySpecInternal)this.getRootSpec().addFirst().into((Object)"META-INF");
        this.metaInf.addChild().from(new Object[]{new Callable<FileTreeAdapter>(){

            @Override
            public FileTreeAdapter call() throws Exception {
                GeneratedSingletonFileTree manifestSource = new GeneratedSingletonFileTree(Jar.this.getTemporaryDirFactory(), "MANIFEST.MF", (Action)new Action<OutputStream>(){

                    public void execute(OutputStream outputStream) {
                        Manifest manifest = Jar.this.getManifest();
                        if (manifest == null) {
                            manifest = new DefaultManifest(null);
                        }
                        ManifestInternal manifestInternal = manifest instanceof ManifestInternal ? (ManifestInternal)manifest : new CustomManifestInternalWrapper(manifest);
                        manifestInternal.setContentCharset(Jar.this.manifestContentCharset);
                        manifestInternal.writeTo(outputStream);
                    }
                });
                return new FileTreeAdapter((MinimalFileTree)manifestSource);
            }
        }});
        this.getMainSpec().appendCachingSafeCopyAction((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails details) {
                if (details.getPath().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    details.exclude();
                }
            }
        });
    }

    public String getMetadataCharset() {
        return super.getMetadataCharset();
    }

    public void setMetadataCharset(String metadataCharset) {
        super.setMetadataCharset(metadataCharset);
    }

    @Input
    public String getManifestContentCharset() {
        return this.manifestContentCharset;
    }

    public void setManifestContentCharset(String manifestContentCharset) {
        if (manifestContentCharset == null) {
            throw new InvalidUserDataException("manifestContentCharset must not be null");
        }
        if (!Charset.isSupported(manifestContentCharset)) {
            throw new InvalidUserDataException(String.format("Charset for manifestContentCharset '%s' is not supported by your JVM", manifestContentCharset));
        }
        this.manifestContentCharset = manifestContentCharset;
    }

    @Internal
    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Jar manifest(Closure<?> configureClosure) {
        ConfigureUtil.configure(configureClosure, (Object)this.forceManifest());
        return this;
    }

    public Jar manifest(Action<? super Manifest> configureAction) {
        configureAction.execute((Object)this.forceManifest());
        return this;
    }

    private Manifest forceManifest() {
        if (this.manifest == null) {
            this.manifest = new DefaultManifest((PathToFileResolver)((ProjectInternal)this.getProject()).getFileResolver());
        }
        return this.manifest;
    }

    @Internal
    public CopySpec getMetaInf() {
        return this.metaInf.addChild();
    }

    public CopySpec metaInf(Closure<?> configureClosure) {
        return (CopySpec)ConfigureUtil.configure(configureClosure, (Object)this.getMetaInf());
    }

    public CopySpec metaInf(Action<? super CopySpec> configureAction) {
        CopySpec metaInf = this.getMetaInf();
        configureAction.execute((Object)metaInf);
        return metaInf;
    }
}

