/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gephi.algorithms.shortestpath.BellmanFordShortestPathAlgorithm;
import org.gephi.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.tools.plugin.ShortestPath;
import org.gephi.tools.spi.NodeClickEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.HeatMapPanel;
import org.gephi.ui.utils.GradientUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HeatMap
implements Tool {
    private ToolEventListener[] listeners;
    private HeatMapPanel heatMapPanel;
    private Color[] gradientColors = new Color[]{new Color(227, 74, 51), new Color(253, 187, 132), new Color(254, 232, 200)};
    private float[] gradientPositions = new float[]{0.0f, 0.5f, 1.0f};
    private boolean dontPaintUnreachable = true;

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.heatMapPanel = null;
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[1];
        this.listeners[0] = new NodeClickEventListener(){

            public void clickNodes(Node[] nodes) {
                try {
                    BellmanFordShortestPathAlgorithm algorithm;
                    DirectedGraph graph;
                    float[] positions;
                    Color[] colors;
                    Node n = nodes[0];
                    if (HeatMap.this.heatMapPanel.isUsePalette()) {
                        colors = HeatMap.this.heatMapPanel.getSelectedPalette().getColors();
                        positions = HeatMap.this.heatMapPanel.getSelectedPalette().getPositions();
                        HeatMap.this.dontPaintUnreachable = true;
                    } else {
                        colors = HeatMap.this.heatMapPanel.getGradientColors();
                        HeatMap.access$202(HeatMap.this, colors);
                        positions = HeatMap.this.heatMapPanel.getGradientPositions();
                        HeatMap.access$302(HeatMap.this, positions);
                        HeatMap.this.dontPaintUnreachable = HeatMap.this.heatMapPanel.isDontPaintUnreachable();
                    }
                    GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                    if (gc.getGraphModel().isDirected()) {
                        graph = gc.getGraphModel().getDirectedGraphVisible();
                        algorithm = new BellmanFordShortestPathAlgorithm(graph, n);
                        algorithm.compute();
                    } else {
                        graph = gc.getGraphModel().getGraphVisible();
                        algorithm = new DijkstraShortestPathAlgorithm((Graph)graph, n);
                        algorithm.compute();
                    }
                    GradientUtils.LinearGradient linearGradient = new GradientUtils.LinearGradient(colors, positions);
                    double maxDistance = algorithm.getMaxDistance();
                    if (!HeatMap.this.dontPaintUnreachable) {
                        maxDistance += 1.0;
                    }
                    if (maxDistance > 0.0) {
                        for (Map.Entry entry : algorithm.getDistances().entrySet()) {
                            Node node = (Node)entry.getKey();
                            if (!Double.isInfinite((Double)entry.getValue())) {
                                float ratio = (float)((Double)entry.getValue() / maxDistance);
                                Color c = linearGradient.getValue(ratio);
                                node.setColor(c);
                                continue;
                            }
                            if (HeatMap.this.dontPaintUnreachable) continue;
                            Color c = colors[colors.length - 1];
                            node.setColor(c);
                        }
                    }
                    Color c = colors[0];
                    n.setColor(c);
                    HeatMap.this.heatMapPanel.setStatus(NbBundle.getMessage(HeatMap.class, (String)"HeatMap.status.maxdistance") + new DecimalFormat("#.##").format(algorithm.getMaxDistance()));
                }
                catch (Exception e) {
                    Logger.getLogger("").log(Level.SEVERE, "", e);
                }
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                HeatMap.this.heatMapPanel = new HeatMapPanel(HeatMap.this.gradientColors, HeatMap.this.gradientPositions, HeatMap.this.dontPaintUnreachable);
                return HeatMap.this.heatMapPanel;
            }

            public String getName() {
                return NbBundle.getMessage(HeatMap.class, (String)"HeatMap.name");
            }

            public Icon getIcon() {
                return new ImageIcon(this.getClass().getResource("/org/gephi/tools/plugin/resources/heatmap.png"));
            }

            public String getDescription() {
                return NbBundle.getMessage(ShortestPath.class, (String)"HeatMap.description");
            }

            public int getPosition() {
                return 150;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }

    static /* synthetic */ Color[] access$202(HeatMap x0, Color[] x1) {
        x0.gradientColors = x1;
        return x1;
    }

    static /* synthetic */ float[] access$302(HeatMap x0, float[] x1) {
        x0.gradientPositions = x1;
        return x1;
    }
}

