define(["layoutManager","playbackManager","inputManager","connectionManager","appRouter","globalize","loading","dom","recordingHelper"],function(layoutManager,playbackManager,inputManager,connectionManager,appRouter,globalize,loading,dom,recordingHelper){"use strict";function playAllFromHere(card,serverId,queue){for(var startIndex,parent=card.parentNode,className=card.classList.length?"."+card.classList[0]:"",cards=parent.querySelectorAll(className+"[data-id]"),ids=[],foundCard=!1,i=0,length=cards.length;i<length;i++)cards[i]===card&&(foundCard=!0,startIndex=i),!foundCard&&queue||ids.push(cards[i].getAttribute("data-id"));var itemsContainer=dom.parentWithClass(card,"itemsContainer");if(itemsContainer&&itemsContainer.fetchData){var queryOptions=queue?{StartIndex:startIndex}:{};return itemsContainer.fetchData(queryOptions).then(function(result){return queue?playbackManager.queue({items:result.Items||result}):playbackManager.play({items:result.Items||result,startIndex:startIndex})})}if(ids.length)return queue?playbackManager.queue({ids:ids,serverId:serverId}):playbackManager.play({ids:ids,serverId:serverId,startIndex:startIndex})}function showContextMenu(card,options){(function(button){var serverId=(button=dom.parentWithAttribute(button,"data-id")).getAttribute("data-serverid"),id=button.getAttribute("data-id"),type=button.getAttribute("data-type"),apiClient=connectionManager.getApiClient(serverId);return"User"===type?apiClient.getUser(id):"Plugin"===type?Promise.resolve(getItemInfoFromCard(button)):"Device"===type?Promise.resolve(getItemInfoFromCard(button)):"Timer"===type?apiClient.getLiveTvTimer(id):"SeriesTimer"===type?apiClient.getLiveTvSeriesTimer(id):apiClient.getItem(apiClient.getCurrentUserId(),id)})(card).then(function(item){var playlistId=card.getAttribute("data-playlistid"),collectionId=card.getAttribute("data-collectionid");if(playlistId){var elem=dom.parentWithAttribute(card,"data-playlistitemid");item.PlaylistItemId=elem?elem.getAttribute("data-playlistitemid"):null}require(["itemContextMenu"],function(itemContextMenu){connectionManager.getApiClient(item.ServerId).getCurrentUser().then(function(user){itemContextMenu.show(Object.assign({item:item,play:!0,queue:!0,playAllFromHere:!item.IsFolder,queueAllFromHere:!item.IsFolder,playlistId:playlistId,collectionId:collectionId,user:user,multiSelect:layoutManager.mobile&&"false"!==card.getAttribute("data-multiselect")},options||{})).then(function(result){"playallfromhere"===result.command||"queueallfromhere"===result.command?executeAction(card,options.positionTo,result.command):"addtoplaylist"===result.command||"addtocollection"===result.command||(result.updated||result.deleted)&&function(childElement,itemsContainer){(itemsContainer=itemsContainer||dom.parentWithAttribute(childElement,"is","emby-itemscontainer"))&&itemsContainer.notifyRefreshNeeded(!0)}(card,options.itemsContainer)})})})})}function getItemInfoFromCard(card){var item={Type:card.getAttribute("data-type"),Id:card.getAttribute("data-id"),ServerId:card.getAttribute("data-serverid"),IsFolder:"true"===card.getAttribute("data-isfolder")},timerId=card.getAttribute("data-timerid");timerId&&(item.TimerId=timerId);var collectionType=card.getAttribute("data-collectiontype");collectionType&&(item.CollectionType=collectionType);var channelId=card.getAttribute("data-channelid");channelId&&(item.ChannelId=channelId);var mediaType=card.getAttribute("data-mediatype");mediaType&&(item.MediaType=mediaType);var seriesId=card.getAttribute("data-seriesid");seriesId&&(item.SeriesId=seriesId);var configpageurl=card.getAttribute("data-configpageurl");configpageurl&&(item.ConfigPageUrl=configpageurl);var startpositionticks=card.getAttribute("data-startpositionticks");return startpositionticks&&(item.StartPositionTicks=parseInt(startpositionticks)),item}function executeAction(card,target,action){target=target||card;var id=card.getAttribute("data-id");id=id||(card=dom.parentWithAttribute(card,"data-id")).getAttribute("data-id");var item=getItemInfoFromCard(card),serverId=item.ServerId,type=item.Type,playableItemId="Program"===type?item.ChannelId:item.Id;if("Photo"===item.MediaType&&"link"===action&&(action="play"),"link"===action)appRouter.showItem(item,{context:card.getAttribute("data-context"),parentId:card.getAttribute("data-parentid")});else if("programdialog"===action)!function(item){require(["recordingCreator"],function(recordingCreator){recordingCreator.show(item.Id,item.ServerId)})}(item);else if("instantmix"===action)playbackManager.instantMix({Id:playableItemId,ServerId:serverId});else if("play"===action||"resume"===action)playbackManager.play({ids:[playableItemId],serverId:serverId,startPositionTicks:item.StartPositionTicks});else if("queue"===action)playbackManager.isPlaying()?(playbackManager.queue({ids:[playableItemId],serverId:serverId}),function(text){require(["toast"],function(toast){toast(text)})}(globalize.translate("MediaQueued"))):playbackManager.queue({ids:[playableItemId],serverId:serverId});else if("playallfromhere"===action)playAllFromHere(card,serverId);else if("queueallfromhere"===action)playAllFromHere(card,serverId,!0);else if("setplaylistindex"===action)playbackManager.setCurrentPlaylistItem(card.getAttribute("data-playlistitemid"));else if("record"===action)!function(serverId,id,type,timerId,seriesTimerId){if("Program"===type||timerId||seriesTimerId){var programId="Program"===type?id:null;recordingHelper.toggleRecording(serverId,programId,timerId,seriesTimerId)}}(serverId,id,type,card.getAttribute("data-timerid"),card.getAttribute("data-seriestimerid"));else if("menu"===action){var options="false"===target.getAttribute("data-playoptions")?{shuffle:!1,instantMix:!1,play:!1,playAllFromHere:!1,queue:!1,queueAllFromHere:!1}:{};options.positionTo=target,showContextMenu(card,options)}else if("edit"===action)!function(itemId,itemType,serverId){var apiClient=connectionManager.getApiClient(serverId);new Promise(function(resolve,reject){var serverId=apiClient.serverInfo().Id;"Timer"===itemType?function(itemId,serverId){connectionManager.getApiClient(serverId).getLiveTvTimer(itemId).then(function(item){return item.ProgramId?require(["recordingCreator"]).then(function(objects){return objects[0].show(item.ProgramId,serverId)}):require(["recordingEditor"]).then(function(objects){return objects[0].show(itemId,serverId)})})}(itemId,serverId):require(["metadataEditor"],function(metadataEditor){metadataEditor.show(itemId,serverId).then(resolve,reject)})})}(item.Id,type,serverId);else if("playtrailer"===action)!function(itemId,serverId){var apiClient=connectionManager.getApiClient(serverId);apiClient.getLocalTrailers(apiClient.getCurrentUserId(),itemId).then(function(trailers){playbackManager.play({items:trailers})})}(item.Id,serverId);else if("addtoplaylist"===action)!function(itemId,serverId){require(["playlistEditor"],function(playlistEditor){(new playlistEditor).show({items:[itemId],serverId:serverId})})}(item.Id,serverId);else if("multiselect"===action){dom.parentWithClass(card,"itemsContainer").showMultiSelect(dom.parentWithClass(card,"card"))}else if("custom"===action){var customAction=target.getAttribute("data-customaction");card.dispatchEvent(new CustomEvent("action-"+customAction,{detail:{playlistItemId:card.getAttribute("data-playlistitemid")},cancelable:!1,bubbles:!0}))}}function onClick(e){var card=dom.parentWithClass(e.target,"itemAction");if(card){var actionElement=card,action=actionElement.getAttribute("data-action");if(action||(actionElement=dom.parentWithAttribute(actionElement,"data-action"))&&(action=actionElement.getAttribute("data-action")),action)return executeAction(card,actionElement,action),e.preventDefault(),e.stopPropagation(),!1}}function onCommand(e){var cmd=e.detail.command;if("play"===cmd||"resume"===cmd||"record"===cmd||"menu"===cmd||"info"===cmd){var target=e.target,card=dom.parentWithClass(target,"itemAction")||dom.parentWithAttribute(target,"data-id");card&&(e.preventDefault(),e.stopPropagation(),executeAction(card,card,cmd))}}return{on:function(context,options){!1!==(options=options||{}).click&&context.addEventListener("click",onClick),!1!==options.command&&inputManager.on(context,onCommand)},off:function(context,options){options=options||{},context.removeEventListener("click",onClick),!1!==options.command&&inputManager.off(context,onCommand)},onClick:onClick,getShortcutAttributesHtml:function(item,serverId){var html='data-id="'+item.Id+'"';(serverId=serverId||item.ServerId)&&(html+=' data-serverid="'+serverId+'"'),item.Type&&(html+=' data-type="'+item.Type+'"'),item.MediaType&&(html+=' data-mediatype="'+item.MediaType+'"'),item.ChannelId&&(html+=' data-channelid="'+item.ChannelId+'"'),item.IsFolder&&(html+=' data-isfolder="true"');var collectionType=item.CollectionType;return collectionType&&(html+=' data-collectiontype="'+collectionType+'"'),item.ConfigPageUrl&&(html+=' data-configpageurl="'+item.ConfigPageUrl+'"'),html}}});