/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.Transports;

public class ConnectionManager
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ConnectionManager.class);
    private final ConcurrentMap<DiscoveryNode, Transport.Connection> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final KeyedLock<String> connectionLock = new KeyedLock();
    private final Map<DiscoveryNode, List<ActionListener<Void>>> connectingNodes = ConcurrentCollections.newConcurrentMap();
    private final AbstractRefCounted connectingRefCounter = new AbstractRefCounted("connection manager"){

        protected void closeInternal() {
            Iterator iterator = ConnectionManager.this.connectedNodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                try {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)next.getValue()});
                }
                finally {
                    iterator.remove();
                }
            }
            ConnectionManager.this.closeLatch.countDown();
        }
    };
    private final Transport transport;
    private final ConnectionProfile defaultProfile;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final DelegatingNodeConnectionListener connectionListener = new DelegatingNodeConnectionListener();

    public ConnectionManager(Settings settings, Transport transport) {
        this(ConnectionProfile.buildDefaultConnectionProfile(settings), transport);
    }

    public ConnectionManager(ConnectionProfile connectionProfile, Transport transport) {
        this.transport = transport;
        this.defaultProfile = connectionProfile;
    }

    public void addListener(TransportConnectionListener listener) {
        this.connectionListener.listeners.addIfAbsent(listener);
    }

    public void removeListener(TransportConnectionListener listener) {
        this.connectionListener.listeners.remove(listener);
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        this.internalOpenConnection(node, resolvedProfile, listener);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        if (node == null) {
            listener.onFailure(new ConnectTransportException(null, "can't connect to a null node"));
            return;
        }
        if (!this.connectingRefCounter.tryIncRef()) {
            listener.onFailure(new IllegalStateException("connection manager is closed"));
            return;
        }
        try (Releasable lock = this.connectionLock.acquire(node.getId());){
            Transport.Connection connection = (Transport.Connection)this.connectedNodes.get(node);
            if (connection != null) {
                assert (!this.connectingNodes.containsKey(node));
                lock.close();
                this.connectingRefCounter.decRef();
                listener.onResponse(null);
                return;
            }
            List connectionListeners = this.connectingNodes.computeIfAbsent(node, n -> new ArrayList());
            connectionListeners.add(listener);
            if (connectionListeners.size() > 1) {
                this.connectingRefCounter.decRef();
                return;
            }
        }
        RunOnce releaseOnce = new RunOnce(() -> ((AbstractRefCounted)this.connectingRefCounter).decRef());
        this.internalOpenConnection(node, resolvedProfile, ActionListener.wrap(conn -> connectionValidator.validate((Transport.Connection)conn, resolvedProfile, ActionListener.wrap(ignored -> {
            List listeners;
            block20: {
                assert (Transports.assertNotTransportThread("connection validator success"));
                boolean success = false;
                listeners = null;
                try {
                    try (Releasable ignored2 = this.connectionLock.acquire(node.getId());){
                        this.connectedNodes.put(node, (Transport.Connection)conn);
                        if (logger.isDebugEnabled()) {
                            logger.debug("connected to node [{}]", (Object)node);
                        }
                        try {
                            this.connectionListener.onNodeConnected(node);
                        }
                        finally {
                            Transport.Connection finalConnection = conn;
                            conn.addCloseListener(ActionListener.wrap(() -> {
                                logger.trace("unregistering {} after connection close and marking as disconnected", (Object)node);
                                this.connectedNodes.remove(node, finalConnection);
                                this.connectionListener.onNodeDisconnected(node);
                            }));
                        }
                        if (conn.isClosed()) {
                            throw new NodeNotConnectedException(node, "connection concurrently closed");
                        }
                        success = true;
                        listeners = this.connectingNodes.remove(node);
                    }
                    if (success) break block20;
                }
                catch (ConnectTransportException e) {
                    try {
                        throw e;
                        catch (Exception e2) {
                            throw new ConnectTransportException(node, "general node connection failure", e2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            logger.trace(() -> new ParameterizedMessage("failed to connect to [{}], cleaning dangling connections", (Object)node));
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{conn});
                            throw throwable;
                        }
                        releaseOnce.run();
                        ActionListener.onResponse(listeners, null);
                        throw throwable;
                    }
                }
                logger.trace(() -> new ParameterizedMessage("failed to connect to [{}], cleaning dangling connections", (Object)node));
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{conn});
                return;
            }
            releaseOnce.run();
            ActionListener.onResponse(listeners, null);
        }, e -> {
            List listeners;
            assert (Transports.assertNotTransportThread("connection validator failure"));
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{conn});
            try (Releasable ignored = this.connectionLock.acquire(node.getId());){
                listeners = this.connectingNodes.remove(node);
            }
            releaseOnce.run();
            ActionListener.onFailure(listeners, e);
        })), e -> {
            List listeners;
            assert (Transports.assertNotTransportThread("internalOpenConnection failure"));
            try (Releasable ignored = this.connectionLock.acquire(node.getId());){
                listeners = this.connectingNodes.remove(node);
            }
            releaseOnce.run();
            if (listeners != null) {
                ActionListener.onFailure(listeners, e);
            }
        }));
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        Transport.Connection connection = (Transport.Connection)this.connectedNodes.get(node);
        if (connection == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return connection;
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        Transport.Connection nodeChannels = (Transport.Connection)this.connectedNodes.remove(node);
        if (nodeChannels != null) {
            nodeChannels.close();
        }
    }

    public int size() {
        return this.connectedNodes.size();
    }

    public Set<DiscoveryNode> connectedNodes() {
        return Collections.unmodifiableSet(this.connectedNodes.keySet());
    }

    @Override
    public void close() {
        this.internalClose(true);
    }

    public void closeNoBlock() {
        this.internalClose(false);
    }

    private void internalClose(boolean waitForPendingConnections) {
        assert (Transports.assertNotTransportThread("Closing ConnectionManager"));
        if (this.closing.compareAndSet(false, true)) {
            this.connectingRefCounter.decRef();
            if (waitForPendingConnections) {
                try {
                    this.closeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void internalOpenConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        this.transport.openConnection(node, connectionProfile, ActionListener.map(listener, connection -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection success"));
            try {
                this.connectionListener.onConnectionOpened((Transport.Connection)connection);
            }
            finally {
                connection.addCloseListener(ActionListener.wrap(() -> this.connectionListener.onConnectionClosed((Transport.Connection)connection)));
            }
            if (connection.isClosed()) {
                throw new ConnectTransportException(node, "a channel closed while connecting");
            }
            return connection;
        }));
    }

    ConnectionProfile getConnectionProfile() {
        return this.defaultProfile;
    }

    private static final class DelegatingNodeConnectionListener
    implements TransportConnectionListener {
        private final CopyOnWriteArrayList<TransportConnectionListener> listeners = new CopyOnWriteArrayList();

        private DelegatingNodeConnectionListener() {
        }

        @Override
        public void onNodeDisconnected(DiscoveryNode key) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeDisconnected(key);
            }
        }

        @Override
        public void onNodeConnected(DiscoveryNode node) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeConnected(node);
            }
        }

        @Override
        public void onConnectionOpened(Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionOpened(connection);
            }
        }

        @Override
        public void onConnectionClosed(Transport.Connection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionClosed(connection);
            }
        }
    }

    @FunctionalInterface
    public static interface ConnectionValidator {
        public void validate(Transport.Connection var1, ConnectionProfile var2, ActionListener<Void> var3);
    }
}

