/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class EListInit
extends AExpression {
    private final List<AExpression> values;
    private PainlessConstructor constructor = null;
    private PainlessMethod method = null;

    public EListInit(Location location, List<AExpression> values) {
        super(location);
        this.values = values;
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AExpression value : this.values) {
            value.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression value : this.values) {
            value.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Must read from list initializer."));
        }
        this.actual = ArrayList.class;
        this.constructor = locals.getPainlessLookup().lookupPainlessConstructor(this.actual, 0);
        if (this.constructor == null) {
            throw this.createError(new IllegalArgumentException("constructor [" + PainlessLookupUtility.typeToCanonicalTypeName(this.actual) + ", <init>/0] not found"));
        }
        this.method = locals.getPainlessLookup().lookupPainlessMethod(this.actual, false, "add", 1);
        if (this.method == null) {
            throw this.createError(new IllegalArgumentException("method [" + PainlessLookupUtility.typeToCanonicalTypeName(this.actual) + ", add/1] not found"));
        }
        for (int index = 0; index < this.values.size(); ++index) {
            AExpression expression = this.values.get(index);
            expression.expected = def.class;
            expression.internal = true;
            expression.analyze(locals);
            this.values.set(index, expression.cast(locals));
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.newInstance(MethodWriter.getType(this.actual));
        writer.dup();
        writer.invokeConstructor(Type.getType(this.constructor.javaConstructor.getDeclaringClass()), Method.getMethod(this.constructor.javaConstructor));
        for (AExpression value : this.values) {
            writer.dup();
            value.write(writer, globals);
            writer.invokeMethodCall(this.method);
            writer.pop();
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.values);
    }
}

