/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.runtime;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstallProvider;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.runtime.JSRuntimeTypeRegistryReader;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JSRuntimeInstallRegistryReader {
    private static final String EXTENSION_NAME = "org.eclipse.wst.jsdt.core.JSRuntimeInstallProvider";
    private static final String RUNTIME_PROVIDER = "runtimeProvider";
    private static final String RUNTIME_TYPE_ID_ATTR = "runtimeTypeId";
    private static final String PROVIDER_CLASS_ATTR = "class";
    private static Collection<IJSRuntimeInstall> runtimeInstalls = null;

    private static boolean isValidJSRuntimeType(String runtimeTypeId) {
        return JSRuntimeTypeRegistryReader.getJSRuntimeTypesIds().contains(runtimeTypeId);
    }

    private static void initRuntimeInstallsCollection() {
        runtimeInstalls = new ArrayList<IJSRuntimeInstall>();
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_NAME);
        if (exp == null) {
            return;
        }
        IExtension[] iExtensionArray = exp.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement providerConfigElements = iConfigurationElementArray[n4];
                if (providerConfigElements.getName().equals(RUNTIME_PROVIDER)) {
                    if (providerConfigElements.getAttribute(PROVIDER_CLASS_ATTR) != null && providerConfigElements.getAttribute(RUNTIME_TYPE_ID_ATTR) != null) {
                        String runtimeTypeId = providerConfigElements.getAttribute(RUNTIME_TYPE_ID_ATTR);
                        if (!JSRuntimeInstallRegistryReader.isValidJSRuntimeType(runtimeTypeId)) {
                            Logger.log(2, "Trying to register a JS runtime install using an invalid runtime type id." + runtimeTypeId + " Runtime types must " + "be registered using extension point org.eclipse.wst.jsdt.core.JSRuntimeType");
                            break;
                        }
                        IJSRuntimeInstallProvider provider = null;
                        try {
                            provider = (IJSRuntimeInstallProvider)providerConfigElements.createExecutableExtension(PROVIDER_CLASS_ATTR);
                        }
                        catch (Exception e) {
                            Util.log(e, "Error instantiating class " + providerConfigElements.getAttribute(PROVIDER_CLASS_ATTR));
                        }
                        if (provider != null) {
                            runtimeInstalls.addAll(provider.getJSRuntimeInstallContributions(JSRuntimeTypeRegistryReader.getJSRuntimeType(runtimeTypeId)));
                        }
                    }
                } else {
                    Logger.log(2, "Unexpected tag " + providerConfigElements.getName() + ". Expected " + RUNTIME_PROVIDER + " instead.");
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static Collection<IJSRuntimeInstall> getJSRuntimeInstalls() {
        if (runtimeInstalls != null) {
            return runtimeInstalls;
        }
        JSRuntimeInstallRegistryReader.initRuntimeInstallsCollection();
        return runtimeInstalls;
    }
}

