/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.eclipse.birt.core.btree.BTreeUtils;
import org.eclipse.birt.core.btree.NodeFile;
import org.eclipse.birt.core.i18n.CoreMessages;

public class RAMBTreeFile
implements NodeFile {
    private ArrayList<byte[]> blocks = new ArrayList();

    @Override
    public void close() {
    }

    @Override
    public int getTotalBlock() {
        return this.blocks.size();
    }

    @Override
    public int allocBlock() throws IOException {
        byte[] block = new byte[4096];
        BTreeUtils.integerToBytes(-1, block);
        this.blocks.add(block);
        return this.blocks.size() - 1;
    }

    @Override
    public void freeBlock(int blockId) throws IOException {
    }

    @Override
    public void readBlock(int blockId, byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (blockId >= this.blocks.size()) {
            throw new EOFException(CoreMessages.getFormattedString("error.ExceedMaxBlock", blockId, this.blocks.size()));
        }
        byte[] block = this.blocks.get(blockId);
        int length = bytes.length > 4096 ? 4096 : bytes.length;
        System.arraycopy(block, 0, bytes, 0, length);
    }

    @Override
    public void writeBlock(int blockId, byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (blockId >= this.blocks.size()) {
            int i = 0;
            while (i <= blockId) {
                byte[] block = new byte[4096];
                BTreeUtils.integerToBytes(-1, block);
                this.blocks.add(block);
                ++i;
            }
        }
        byte[] block = this.blocks.get(blockId);
        int length = bytes.length > 4096 ? 4096 : bytes.length;
        System.arraycopy(bytes, 0, block, 0, length);
    }

    public void read(String file) throws IOException {
        this.blocks.clear();
        RandomAccessFile rf = new RandomAccessFile(file, "r");
        try {
            int blockCount = (int)(rf.length() / 4096L);
            byte[] block = new byte[4096];
            int i = 0;
            while (i < blockCount) {
                rf.readFully(block);
                this.blocks.add(block);
                ++i;
            }
        }
        finally {
            rf.close();
        }
    }

    public void read(InputStream in) throws IOException {
        this.blocks.clear();
        DataInputStream data = new DataInputStream(in);
        try {
            while (true) {
                byte[] block = new byte[4096];
                data.readFully(block);
                this.blocks.add(block);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public void write(String file) throws IOException {
        RandomAccessFile rf = new RandomAccessFile(file, "w");
        try {
            int blockCount = this.blocks.size();
            int i = 0;
            while (i < blockCount) {
                byte[] block = this.blocks.get(i);
                rf.write(block);
                ++i;
            }
        }
        finally {
            rf.close();
        }
    }

    @Override
    public Object lock() throws IOException {
        return this;
    }

    @Override
    public void unlock(Object lock) throws IOException {
    }
}

