/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.AddArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.AndBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.DivArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.EqualsBinaryRelationalOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.GreaterThanEqRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.GreaterThanRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.LessThanEqRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.LessThanRelationalBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.ModArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.MultiplyArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.NotEqualsBinaryRelationalOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.OrBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.SubtractArithmeticBinaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class BinaryOperator {
    protected final DiagnosticFactory _diagnosticFactory;

    public static BinaryOperator getBinaryOperator(Token operatorToken, DiagnosticFactory diagnosticFactory, IStructuredDocumentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        String facetVersion = BinaryOperator.determineJSFVersion(context);
        switch (operatorToken.kind) {
            case 41: 
            case 42: {
                return new AndBinaryOperator(diagnosticFactory);
            }
            case 43: 
            case 44: {
                return new OrBinaryOperator(diagnosticFactory);
            }
            case 18: 
            case 19: {
                return new EqualsBinaryRelationalOperator(diagnosticFactory, facetVersion);
            }
            case 24: 
            case 25: {
                return new NotEqualsBinaryRelationalOperator(diagnosticFactory, facetVersion);
            }
            case 14: 
            case 15: {
                return new GreaterThanRelationalBinaryOperator(diagnosticFactory, facetVersion);
            }
            case 22: 
            case 23: {
                return new GreaterThanEqRelationalBinaryOperator(diagnosticFactory, facetVersion);
            }
            case 16: 
            case 17: {
                return new LessThanRelationalBinaryOperator(diagnosticFactory, facetVersion);
            }
            case 20: 
            case 21: {
                return new LessThanEqRelationalBinaryOperator(diagnosticFactory, facetVersion);
            }
            case 32: {
                return new AddArithmeticBinaryOperator(diagnosticFactory);
            }
            case 33: {
                return new SubtractArithmeticBinaryOperator(diagnosticFactory);
            }
            case 34: {
                return new MultiplyArithmeticBinaryOperator(diagnosticFactory);
            }
            case 35: 
            case 36: {
                return new DivArithmeticBinaryOperator(diagnosticFactory);
            }
            case 37: 
            case 38: {
                return new ModArithmeticBinaryOperator(diagnosticFactory);
            }
        }
        throw new IllegalArgumentException("Unknown binary operator: " + operatorToken.image);
    }

    BinaryOperator(DiagnosticFactory diagnosticFactory) {
        this._diagnosticFactory = diagnosticFactory;
    }

    public abstract ValueType performOperation(ValueType var1, ValueType var2);

    public abstract Diagnostic validate(ValueType var1, ValueType var2);

    private static String determineJSFVersion(IStructuredDocumentContext context) {
        IWorkspaceContextResolver wkResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        IProject project = wkResolver.getProject();
        IProjectFacetVersion projectVersion = JSFAppConfigUtils.getProjectFacet(project);
        if (projectVersion != null) {
            return projectVersion.getVersionString();
        }
        return null;
    }
}

