/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;

public class MultiplexingDocumentBuilder
extends DocumentBuilder {
    private final List<DocumentBuilder> builders = new ArrayList<DocumentBuilder>();

    public MultiplexingDocumentBuilder(DocumentBuilder ... delegates) {
        this.builders.addAll(Arrays.asList(delegates));
    }

    public void addDocumentBuilder(DocumentBuilder delegate) {
        this.builders.add(delegate);
    }

    @Override
    public void acronym(String text, String definition) {
        for (DocumentBuilder builder : this.builders) {
            builder.acronym(text, definition);
        }
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        for (DocumentBuilder builder : this.builders) {
            builder.beginBlock(type, attributes);
        }
    }

    @Override
    public void beginDocument() {
        for (DocumentBuilder builder : this.builders) {
            builder.beginDocument();
        }
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        for (DocumentBuilder builder : this.builders) {
            builder.beginHeading(level, attributes);
        }
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        for (DocumentBuilder builder : this.builders) {
            builder.beginSpan(type, attributes);
        }
    }

    @Override
    public void characters(String text) {
        for (DocumentBuilder builder : this.builders) {
            builder.characters(text);
        }
    }

    @Override
    public void charactersUnescaped(String literal) {
        for (DocumentBuilder builder : this.builders) {
            builder.charactersUnescaped(literal);
        }
    }

    @Override
    public void endBlock() {
        for (DocumentBuilder builder : this.builders) {
            builder.endBlock();
        }
    }

    @Override
    public void endDocument() {
        for (DocumentBuilder builder : this.builders) {
            builder.endDocument();
        }
    }

    @Override
    public void flush() {
        for (DocumentBuilder builder : this.builders) {
            builder.flush();
        }
    }

    @Override
    public void endHeading() {
        for (DocumentBuilder builder : this.builders) {
            builder.endHeading();
        }
    }

    @Override
    public void endSpan() {
        for (DocumentBuilder builder : this.builders) {
            builder.endSpan();
        }
    }

    @Override
    public void entityReference(String entity) {
        for (DocumentBuilder builder : this.builders) {
            builder.entityReference(entity);
        }
    }

    @Override
    public void image(Attributes attributes, String url) {
        for (DocumentBuilder builder : this.builders) {
            builder.image(attributes, url);
        }
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        for (DocumentBuilder builder : this.builders) {
            builder.imageLink(linkAttributes, imageAttributes, href, imageUrl);
        }
    }

    @Override
    public void lineBreak() {
        for (DocumentBuilder builder : this.builders) {
            builder.lineBreak();
        }
    }

    @Override
    public void horizontalRule() {
        for (DocumentBuilder builder : this.builders) {
            builder.horizontalRule();
        }
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        for (DocumentBuilder builder : this.builders) {
            builder.link(attributes, hrefOrHashName, text);
        }
    }

    @Override
    public void setLocator(Locator locator) {
        super.setLocator(locator);
        for (DocumentBuilder builder : this.builders) {
            builder.setLocator(locator);
        }
    }
}

