﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/managedblockchain/ManagedBlockchain_EXPORTS.h>
#include <aws/managedblockchain/model/Member.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace ManagedBlockchain
{
namespace Model
{
  class AWS_MANAGEDBLOCKCHAIN_API GetMemberResult
  {
  public:
    GetMemberResult();
    GetMemberResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    GetMemberResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>The properties of a member.</p>
     */
    inline const Member& GetMember() const{ return m_member; }

    /**
     * <p>The properties of a member.</p>
     */
    inline void SetMember(const Member& value) { m_member = value; }

    /**
     * <p>The properties of a member.</p>
     */
    inline void SetMember(Member&& value) { m_member = std::move(value); }

    /**
     * <p>The properties of a member.</p>
     */
    inline GetMemberResult& WithMember(const Member& value) { SetMember(value); return *this;}

    /**
     * <p>The properties of a member.</p>
     */
    inline GetMemberResult& WithMember(Member&& value) { SetMember(std::move(value)); return *this;}

  private:

    Member m_member;
  };

} // namespace Model
} // namespace ManagedBlockchain
} // namespace Aws
