"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.TextEditorContext = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _eventKit = require("event-kit");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const editorUpdateProps = {
  mini: _propTypes["default"].bool,
  readOnly: _propTypes["default"].bool,
  placeholderText: _propTypes["default"].string,
  lineNumberGutterVisible: _propTypes["default"].bool,
  autoHeight: _propTypes["default"].bool,
  autoWidth: _propTypes["default"].bool,
  softWrapped: _propTypes["default"].bool
};

const editorCreationProps = _objectSpread({
  buffer: _propTypes["default"].object
}, editorUpdateProps);

const EMPTY_CLASS = 'github-AtomTextEditor-empty';

const TextEditorContext = _react["default"].createContext();

exports.TextEditorContext = TextEditorContext;

class AtomTextEditor extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "observeSelections", selection => {
      const selectionSubs = new _eventKit.CompositeDisposable(selection.onDidChangeRange(this.props.didChangeSelectionRange), selection.onDidDestroy(() => {
        selectionSubs.dispose();
        this.subs.remove(selectionSubs);
        this.props.didDestroySelection(selection);
      }));
      this.subs.add(selectionSubs);
      this.props.didAddSelection(selection);
    });

    _defineProperty(this, "observeEmptiness", () => {
      this.getRefModel().map(editor => {
        if (editor.isEmpty() && this.props.hideEmptiness) {
          this.refElement.map(element => element.classList.add(EMPTY_CLASS));
        } else {
          this.refElement.map(element => element.classList.remove(EMPTY_CLASS));
        }

        return null;
      });
    });

    this.subs = new _eventKit.CompositeDisposable();
    this.refParent = new _refHolder["default"]();
    this.refElement = new _refHolder["default"]();
    this.refModel = null;
  }

  render() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("div", {
      className: "github-AtomTextEditor-container",
      ref: this.refParent.setter
    }), _react["default"].createElement(TextEditorContext.Provider, {
      value: this.getRefModel()
    }, this.props.children));
  }

  componentDidMount() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorCreationProps);
    this.refParent.map(element => {
      const editor = new _atom.TextEditor(modelProps);
      element.appendChild(editor.getElement());
      this.getRefModel().setter(editor);
      this.refElement.setter(editor.getElement());
      this.subs.add(editor.onDidChangeCursorPosition(this.props.didChangeCursorPosition), editor.observeSelections(this.observeSelections), editor.onDidChange(this.observeEmptiness));

      if (editor.isEmpty() && this.props.hideEmptiness) {
        editor.getElement().classList.add(EMPTY_CLASS);
      }

      return null;
    });
  }

  componentDidUpdate() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorUpdateProps);
    this.getRefModel().map(editor => editor.update(modelProps)); // When you look into the abyss, the abyss also looks into you

    this.observeEmptiness();
  }

  componentWillUnmount() {
    this.getRefModel().map(editor => editor.destroy());
    this.subs.dispose();
  }

  contains(element) {
    return this.refElement.map(e => e.contains(element)).getOr(false);
  }

  focus() {
    this.refElement.map(e => e.focus());
  }

  getRefModel() {
    if (this.props.refModel) {
      return this.props.refModel;
    }

    if (!this.refModel) {
      this.refModel = new _refHolder["default"]();
    }

    return this.refModel;
  }

  getModel() {
    return this.getRefModel().getOr(undefined);
  }

}

exports["default"] = AtomTextEditor;

_defineProperty(AtomTextEditor, "propTypes", _objectSpread({}, editorCreationProps, {
  didChangeCursorPosition: _propTypes["default"].func,
  didAddSelection: _propTypes["default"].func,
  didChangeSelectionRange: _propTypes["default"].func,
  didDestroySelection: _propTypes["default"].func,
  hideEmptiness: _propTypes["default"].bool,
  refModel: _propTypes2.RefHolderPropType,
  children: _propTypes["default"].node
}));

_defineProperty(AtomTextEditor, "defaultProps", {
  didChangeCursorPosition: () => {},
  didAddSelection: () => {},
  didChangeSelectionRange: () => {},
  didDestroySelection: () => {},
  hideEmptiness: false
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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