//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.3
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Locator_h__
#define __Ice_Locator_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/Identity.h>
#include <Ice/Process.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 3
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class LocatorRegistry;
class LocatorRegistryPrx;
class Locator;
class LocatorPrx;
class LocatorFinder;
class LocatorFinderPrx;

}

namespace Ice
{

/**
 * This exception is raised if an adapter cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) AdapterNotFoundException : public UserExceptionHelper<AdapterNotFoundException, UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~AdapterNotFoundException();

    AdapterNotFoundException(const AdapterNotFoundException&) = default;

    AdapterNotFoundException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static AdapterNotFoundException _iceS_AdapterNotFoundException_init;
/// \endcond

/**
 * This exception is raised if the replica group provided by the
 * server is invalid.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) InvalidReplicaGroupIdException : public UserExceptionHelper<InvalidReplicaGroupIdException, UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvalidReplicaGroupIdException();

    InvalidReplicaGroupIdException(const InvalidReplicaGroupIdException&) = default;

    InvalidReplicaGroupIdException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/**
 * This exception is raised if a server tries to set endpoints for
 * an adapter that is already active.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) AdapterAlreadyActiveException : public UserExceptionHelper<AdapterAlreadyActiveException, UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~AdapterAlreadyActiveException();

    AdapterAlreadyActiveException(const AdapterAlreadyActiveException&) = default;

    AdapterAlreadyActiveException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/**
 * This exception is raised if an object cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ObjectNotFoundException : public UserExceptionHelper<ObjectNotFoundException, UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ObjectNotFoundException();

    ObjectNotFoundException(const ObjectNotFoundException&) = default;

    ObjectNotFoundException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/**
 * This exception is raised if a server cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ServerNotFoundException : public UserExceptionHelper<ServerNotFoundException, UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ServerNotFoundException();

    ServerNotFoundException(const ServerNotFoundException&) = default;

    ServerNotFoundException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

}

namespace Ice
{

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 * \headerfile Ice/Ice.h
 */
class ICE_API Locator : public virtual Object
{
public:

    using ProxyType = LocatorPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Ice::ObjectNotFoundException Raised if the object cannot
     * be found.
     */
    virtual void findObjectByIdAsync(Identity id, ::std::function<void(const ::std::shared_ptr<ObjectPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectById(::IceInternal::Incoming&, const Current&) const;
    /// \endcond

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot be
     * found.
     */
    virtual void findAdapterByIdAsync(::std::string id, ::std::function<void(const ::std::shared_ptr<ObjectPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_findAdapterById(::IceInternal::Incoming&, const Current&) const;
    /// \endcond

    /**
     * Get the locator registry.
     * @param current The Current object for the invocation.
     * @return The locator registry.
     */
    virtual ::std::shared_ptr<LocatorRegistryPrx> getRegistry(const Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistry(::IceInternal::Incoming&, const Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

/**
 * The Ice locator registry interface. This interface is used by
 * servers to register adapter endpoints with the locator.
 *
 * <p class="Note"> The {@link LocatorRegistry} interface is intended to be used
 * by Ice internals and by locator implementations. Regular user
 * code should not attempt to use any functionality of this interface
 * directly.
 * \headerfile Ice/Ice.h
 */
class ICE_API LocatorRegistry : public virtual Object
{
public:

    using ProxyType = LocatorRegistryPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     */
    virtual void setAdapterDirectProxyAsync(::std::string id, ::std::shared_ptr<ObjectPrx> proxy, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setAdapterDirectProxy(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     * @throws Ice::InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     */
    virtual void setReplicatedAdapterDirectProxyAsync(::std::string adapterId, ::std::string replicaGroupId, ::std::shared_ptr<ObjectPrx> p, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setReplicatedAdapterDirectProxy(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws Ice::ServerNotFoundException Raised if the server cannot
     * be found.
     */
    virtual void setServerProcessProxyAsync(::std::string id, ::std::shared_ptr<ProcessPrx> proxy, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setServerProcessProxy(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

/**
 * This inferface should be implemented by services implementing the
 * Ice::Locator interface. It should be advertised through an Ice
 * object with the identity `Ice/LocatorFinder'. This allows clients
 * to retrieve the locator proxy with just the endpoint information of
 * the service.
 * \headerfile Ice/Ice.h
 */
class ICE_API LocatorFinder : public virtual Object
{
public:

    using ProxyType = LocatorFinderPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param current The Current object for the invocation.
     * @return The locator proxy.
     */
    virtual ::std::shared_ptr<LocatorPrx> getLocator(const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getLocator(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

}

namespace Ice
{

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) LocatorPrx : public virtual Proxy<LocatorPrx, ObjectPrx>
{
public:

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy, or null if the object is not active.
     * @throws Ice::ObjectNotFoundException Raised if the object cannot
     * be found.
     */
    ::std::shared_ptr<ObjectPrx> findObjectById(const Identity& id, const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &LocatorPrx::_iceI_findObjectById, id, context).get();
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findObjectByIdAsync(const Identity& id, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &LocatorPrx::_iceI_findObjectById, id, context);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findObjectByIdAsync(const Identity& id,
                        ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &Ice::LocatorPrx::_iceI_findObjectById, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const Identity&, const Context&);
    /// \endcond

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot be
     * found.
     */
    ::std::shared_ptr<ObjectPrx> findAdapterById(const ::std::string& id, const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &LocatorPrx::_iceI_findAdapterById, id, context).get();
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findAdapterByIdAsync(const ::std::string& id, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &LocatorPrx::_iceI_findAdapterById, id, context);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findAdapterByIdAsync(const ::std::string& id,
                         ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &Ice::LocatorPrx::_iceI_findAdapterById, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_findAdapterById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const Context&);
    /// \endcond

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @return The locator registry.
     */
    ::std::shared_ptr<LocatorRegistryPrx> getRegistry(const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorRegistryPrx>>(true, this, &LocatorPrx::_iceI_getRegistry, context).get();
    }

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getRegistryAsync(const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::LocatorRegistryPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorRegistryPrx>, P>(false, this, &LocatorPrx::_iceI_getRegistry, context);
    }

    /**
     * Get the locator registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getRegistryAsync(::std::function<void(::std::shared_ptr<::Ice::LocatorRegistryPrx>)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::LocatorRegistryPrx>>(response, ex, sent, this, &Ice::LocatorPrx::_iceI_getRegistry, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::LocatorRegistryPrx>>>&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LocatorPrx() = default;
    friend ::std::shared_ptr<LocatorPrx> IceInternal::createProxy<LocatorPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The Ice locator registry interface. This interface is used by
 * servers to register adapter endpoints with the locator.
 *
 * <p class="Note"> The {@link LocatorRegistry} interface is intended to be used
 * by Ice internals and by locator implementations. Regular user
 * code should not attempt to use any functionality of this interface
 * directly.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) LocatorRegistryPrx : public virtual Proxy<LocatorRegistryPrx, ObjectPrx>
{
public:

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     */
    void setAdapterDirectProxy(const ::std::string& id, const ::std::shared_ptr<ObjectPrx>& proxy, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LocatorRegistryPrx::_iceI_setAdapterDirectProxy, id, proxy, context).get();
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setAdapterDirectProxyAsync(const ::std::string& id, const ::std::shared_ptr<ObjectPrx>& proxy, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LocatorRegistryPrx::_iceI_setAdapterDirectProxy, id, proxy, context);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setAdapterDirectProxyAsync(const ::std::string& id, const ::std::shared_ptr<ObjectPrx>& proxy,
                               ::std::function<void()> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LocatorRegistryPrx::_iceI_setAdapterDirectProxy, id, proxy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_setAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::shared_ptr<ObjectPrx>&, const Context&);
    /// \endcond

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     * @throws Ice::InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     */
    void setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::std::shared_ptr<ObjectPrx>& p, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy, adapterId, replicaGroupId, p, context).get();
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setReplicatedAdapterDirectProxyAsync(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::std::shared_ptr<ObjectPrx>& p, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy, adapterId, replicaGroupId, p, context);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setReplicatedAdapterDirectProxyAsync(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::std::shared_ptr<ObjectPrx>& p,
                                         ::std::function<void()> response,
                                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                         ::std::function<void(bool)> sent = nullptr,
                                         const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LocatorRegistryPrx::_iceI_setReplicatedAdapterDirectProxy, adapterId, replicaGroupId, p, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_setReplicatedAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::std::shared_ptr<ObjectPrx>&, const Context&);
    /// \endcond

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param context The Context map to send with the invocation.
     * @throws Ice::ServerNotFoundException Raised if the server cannot
     * be found.
     */
    void setServerProcessProxy(const ::std::string& id, const ::std::shared_ptr<ProcessPrx>& proxy, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LocatorRegistryPrx::_iceI_setServerProcessProxy, id, proxy, context).get();
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setServerProcessProxyAsync(const ::std::string& id, const ::std::shared_ptr<ProcessPrx>& proxy, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LocatorRegistryPrx::_iceI_setServerProcessProxy, id, proxy, context);
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setServerProcessProxyAsync(const ::std::string& id, const ::std::shared_ptr<ProcessPrx>& proxy,
                               ::std::function<void()> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LocatorRegistryPrx::_iceI_setServerProcessProxy, id, proxy, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_setServerProcessProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::shared_ptr<ProcessPrx>&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LocatorRegistryPrx() = default;
    friend ::std::shared_ptr<LocatorRegistryPrx> IceInternal::createProxy<LocatorRegistryPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * This inferface should be implemented by services implementing the
 * Ice::Locator interface. It should be advertised through an Ice
 * object with the identity `Ice/LocatorFinder'. This allows clients
 * to retrieve the locator proxy with just the endpoint information of
 * the service.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) LocatorFinderPrx : public virtual Proxy<LocatorFinderPrx, ObjectPrx>
{
public:

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The locator proxy.
     */
    ::std::shared_ptr<LocatorPrx> getLocator(const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorPrx>>(true, this, &LocatorFinderPrx::_iceI_getLocator, context).get();
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLocatorAsync(const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::LocatorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::LocatorPrx>, P>(false, this, &LocatorFinderPrx::_iceI_getLocator, context);
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLocatorAsync(::std::function<void(::std::shared_ptr<::Ice::LocatorPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::LocatorPrx>>(response, ex, sent, this, &Ice::LocatorFinderPrx::_iceI_getLocator, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getLocator(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::LocatorPrx>>>&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LocatorFinderPrx() = default;
    friend ::std::shared_ptr<LocatorFinderPrx> IceInternal::createProxy<LocatorFinderPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace Ice
{

using LocatorRegistryPtr = ::std::shared_ptr<LocatorRegistry>;
using LocatorRegistryPrxPtr = ::std::shared_ptr<LocatorRegistryPrx>;

using LocatorPtr = ::std::shared_ptr<Locator>;
using LocatorPrxPtr = ::std::shared_ptr<LocatorPrx>;

using LocatorFinderPtr = ::std::shared_ptr<LocatorFinder>;
using LocatorFinderPrxPtr = ::std::shared_ptr<LocatorFinderPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Ice
{

class LocatorRegistry;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< LocatorRegistry>&);
ICE_API ::IceProxy::Ice::Object* upCast(LocatorRegistry*);
/// \endcond

class Locator;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Locator>&);
ICE_API ::IceProxy::Ice::Object* upCast(Locator*);
/// \endcond

class LocatorFinder;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< LocatorFinder>&);
ICE_API ::IceProxy::Ice::Object* upCast(LocatorFinder*);
/// \endcond

}

}

namespace Ice
{

class LocatorRegistry;
/// \cond INTERNAL
ICE_API Object* upCast(LocatorRegistry*);
/// \endcond
typedef ::IceInternal::Handle< LocatorRegistry> LocatorRegistryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorRegistry> LocatorRegistryPrx;
typedef LocatorRegistryPrx LocatorRegistryPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(LocatorRegistryPtr&, const ObjectPtr&);
/// \endcond

class Locator;
/// \cond INTERNAL
ICE_API Object* upCast(Locator*);
/// \endcond
typedef ::IceInternal::Handle< Locator> LocatorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::Locator> LocatorPrx;
typedef LocatorPrx LocatorPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(LocatorPtr&, const ObjectPtr&);
/// \endcond

class LocatorFinder;
/// \cond INTERNAL
ICE_API Object* upCast(LocatorFinder*);
/// \endcond
typedef ::IceInternal::Handle< LocatorFinder> LocatorFinderPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorFinder> LocatorFinderPrx;
typedef LocatorFinderPrx LocatorFinderPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(LocatorFinderPtr&, const ObjectPtr&);
/// \endcond

}

namespace Ice
{

/**
 * This exception is raised if an adapter cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_API AdapterNotFoundException : public UserException
{
public:

    AdapterNotFoundException() {}
    virtual ~AdapterNotFoundException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AdapterNotFoundException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(OutputStream*) const;
    virtual void _readImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static AdapterNotFoundException _iceS_AdapterNotFoundException_init;
/// \endcond

/**
 * This exception is raised if the replica group provided by the
 * server is invalid.
 * \headerfile Ice/Ice.h
 */
class ICE_API InvalidReplicaGroupIdException : public UserException
{
public:

    InvalidReplicaGroupIdException() {}
    virtual ~InvalidReplicaGroupIdException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual InvalidReplicaGroupIdException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(OutputStream*) const;
    virtual void _readImpl(InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a server tries to set endpoints for
 * an adapter that is already active.
 * \headerfile Ice/Ice.h
 */
class ICE_API AdapterAlreadyActiveException : public UserException
{
public:

    AdapterAlreadyActiveException() {}
    virtual ~AdapterAlreadyActiveException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AdapterAlreadyActiveException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(OutputStream*) const;
    virtual void _readImpl(InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an object cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_API ObjectNotFoundException : public UserException
{
public:

    ObjectNotFoundException() {}
    virtual ~ObjectNotFoundException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ObjectNotFoundException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(OutputStream*) const;
    virtual void _readImpl(InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a server cannot be found.
 * \headerfile Ice/Ice.h
 */
class ICE_API ServerNotFoundException : public UserException
{
public:

    ServerNotFoundException() {}
    virtual ~ServerNotFoundException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ServerNotFoundException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(OutputStream*) const;
    virtual void _readImpl(InputStream*);
    /// \endcond
};

}

namespace Ice
{

/**
 * AMD callback class for Ice::Locator::findObjectById_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICE_API AMD_Locator_findObjectById : public virtual AMDCallback
{
public:

    virtual ~AMD_Locator_findObjectById();

    /**
     * Call ice_response for a successful completion.
     * @param result The proxy, or null if the object is not active.
     */
    virtual void ice_response(const ObjectPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_Locator_findObjectById> AMD_Locator_findObjectByIdPtr;

/**
 * AMD callback class for Ice::Locator::findAdapterById_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICE_API AMD_Locator_findAdapterById : public virtual AMDCallback
{
public:

    virtual ~AMD_Locator_findAdapterById();

    /**
     * Call ice_response for a successful completion.
     * @param result The adapter proxy, or null if the adapter is not active.
     */
    virtual void ice_response(const ObjectPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_Locator_findAdapterById> AMD_Locator_findAdapterByIdPtr;

/**
 * AMD callback class for Ice::LocatorRegistry::setAdapterDirectProxy_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICE_API AMD_LocatorRegistry_setAdapterDirectProxy : public virtual AMDCallback
{
public:

    virtual ~AMD_LocatorRegistry_setAdapterDirectProxy();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_LocatorRegistry_setAdapterDirectProxy> AMD_LocatorRegistry_setAdapterDirectProxyPtr;

/**
 * AMD callback class for Ice::LocatorRegistry::setReplicatedAdapterDirectProxy_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICE_API AMD_LocatorRegistry_setReplicatedAdapterDirectProxy : public virtual AMDCallback
{
public:

    virtual ~AMD_LocatorRegistry_setReplicatedAdapterDirectProxy();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy> AMD_LocatorRegistry_setReplicatedAdapterDirectProxyPtr;

/**
 * AMD callback class for Ice::LocatorRegistry::setServerProcessProxy_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICE_API AMD_LocatorRegistry_setServerProcessProxy : public virtual AMDCallback
{
public:

    virtual ~AMD_LocatorRegistry_setServerProcessProxy();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::Ice::AMD_LocatorRegistry_setServerProcessProxy> AMD_LocatorRegistry_setServerProcessProxyPtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace Ice
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICE_API AMD_Locator_findObjectById : public ::Ice::AMD_Locator_findObjectById, public ::IceInternal::IncomingAsync
{
public:

    AMD_Locator_findObjectById(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICE_API AMD_Locator_findAdapterById : public ::Ice::AMD_Locator_findAdapterById, public ::IceInternal::IncomingAsync
{
public:

    AMD_Locator_findAdapterById(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICE_API AMD_LocatorRegistry_setAdapterDirectProxy : public ::Ice::AMD_LocatorRegistry_setAdapterDirectProxy, public ::IceInternal::IncomingAsync
{
public:

    AMD_LocatorRegistry_setAdapterDirectProxy(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICE_API AMD_LocatorRegistry_setReplicatedAdapterDirectProxy : public ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy, public ::IceInternal::IncomingAsync
{
public:

    AMD_LocatorRegistry_setReplicatedAdapterDirectProxy(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICE_API AMD_LocatorRegistry_setServerProcessProxy : public ::Ice::AMD_LocatorRegistry_setServerProcessProxy, public ::IceInternal::IncomingAsync
{
public:

    AMD_LocatorRegistry_setServerProcessProxy(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace Ice
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Locator::begin_findObjectById.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_findObjectById.
 */
class Callback_Locator_findObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_findObjectById_Base> Callback_Locator_findObjectByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Locator::begin_findAdapterById.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_findAdapterById.
 */
class Callback_Locator_findAdapterById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_findAdapterById_Base> Callback_Locator_findAdapterByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Locator::begin_getRegistry.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_getRegistry.
 */
class Callback_Locator_getRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_getRegistry_Base> Callback_Locator_getRegistryPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setAdapterDirectProxy.
 */
class Callback_LocatorRegistry_setAdapterDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorRegistry_setAdapterDirectProxy_Base> Callback_LocatorRegistry_setAdapterDirectProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy.
 */
class Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setServerProcessProxy.
 */
class Callback_LocatorRegistry_setServerProcessProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorRegistry_setServerProcessProxy_Base> Callback_LocatorRegistry_setServerProcessProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LocatorFinder::begin_getLocator.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorFinder_getLocator.
 */
class Callback_LocatorFinder_getLocator_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LocatorFinder_getLocator_Base> Callback_LocatorFinder_getLocatorPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_CLASS(ICE_API) Locator : public virtual ::Ice::Proxy<Locator, ::IceProxy::Ice::Object>
{
public:

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The proxy, or null if the object is not active.
     * @throws Ice::ObjectNotFoundException Raised if the object cannot
     * be found.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectById(_iceI_begin_findObjectById(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectById(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, context, cb, cookie);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Callback_Locator_findObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param id The identity.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::Callback_Locator_findObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findObjectById.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy, or null if the object is not active.
     * @throws Ice::ObjectNotFoundException Raised if the object cannot
     * be found.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx end_findObjectById(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectById(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx findAdapterById(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findAdapterById(_iceI_begin_findAdapterById(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAdapterById(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(id, context, cb, cookie);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& id, const ::Ice::Callback_Locator_findAdapterByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& id, const ::Ice::Context& context, const ::Ice::Callback_Locator_findAdapterByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findAdapterById.
     * @param result The asynchronous result object for the invocation.
     * @return The adapter proxy, or null if the adapter is not active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot be
     * found.
     */
    ICE_MEMBER(ICE_API) ::Ice::ObjectPrx end_findAdapterById(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_findAdapterById(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @return The locator registry.
     */
    ICE_MEMBER(ICE_API) ::Ice::LocatorRegistryPrx getRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistry(_iceI_begin_getRegistry(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistry(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the locator registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(context, cb, cookie);
    }

    /**
     * Get the locator registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Callback_Locator_getRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the locator registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getRegistry(const ::Ice::Context& context, const ::Ice::Callback_Locator_getRegistryPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistry(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getRegistry.
     * @param result The asynchronous result object for the invocation.
     * @return The locator registry.
     */
    ICE_MEMBER(ICE_API) ::Ice::LocatorRegistryPrx end_getRegistry(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getRegistry(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) LocatorRegistry : public virtual ::Ice::Proxy<LocatorRegistry, ::IceProxy::Ice::Object>
{
public:

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     */
    ICE_MEMBER(ICE_API) void setAdapterDirectProxy(const ::std::string& id, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setAdapterDirectProxy(_iceI_begin_setAdapterDirectProxy(id, proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& id, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setAdapterDirectProxy(id, proxy, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& id, const ::Ice::ObjectPrx& proxy, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(id, proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& id, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(id, proxy, context, cb, cookie);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& id, const ::Ice::ObjectPrx& proxy, const ::Ice::Callback_LocatorRegistry_setAdapterDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(id, proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& id, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::Ice::Callback_LocatorRegistry_setAdapterDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(id, proxy, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setAdapterDirectProxy.
     * @param result The asynchronous result object for the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     */
    ICE_MEMBER(ICE_API) void end_setAdapterDirectProxy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setAdapterDirectProxy(const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     * @throws Ice::InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     */
    ICE_MEMBER(ICE_API) void setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& p, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setReplicatedAdapterDirectProxy(_iceI_begin_setReplicatedAdapterDirectProxy(adapterId, replicaGroupId, p, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& p, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(adapterId, replicaGroupId, p, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& p, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(adapterId, replicaGroupId, p, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& p, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(adapterId, replicaGroupId, p, context, cb, cookie);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& p, const ::Ice::Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(adapterId, replicaGroupId, p, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the adapter endpoints with the locator registry.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicatedAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& p, const ::Ice::Context& context, const ::Ice::Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicatedAdapterDirectProxy(adapterId, replicaGroupId, p, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setReplicatedAdapterDirectProxy.
     * @param result The asynchronous result object for the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     * @throws Ice::InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     */
    ICE_MEMBER(ICE_API) void end_setReplicatedAdapterDirectProxy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setReplicatedAdapterDirectProxy(const ::std::string&, const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param context The Context map to send with the invocation.
     * @throws Ice::ServerNotFoundException Raised if the server cannot
     * be found.
     */
    ICE_MEMBER(ICE_API) void setServerProcessProxy(const ::std::string& id, const ::Ice::ProcessPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setServerProcessProxy(_iceI_begin_setServerProcessProxy(id, proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& id, const ::Ice::ProcessPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setServerProcessProxy(id, proxy, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& id, const ::Ice::ProcessPrx& proxy, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(id, proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& id, const ::Ice::ProcessPrx& proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(id, proxy, context, cb, cookie);
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& id, const ::Ice::ProcessPrx& proxy, const ::Ice::Callback_LocatorRegistry_setServerProcessProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(id, proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the process proxy for a server.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setServerProcessProxy(const ::std::string& id, const ::Ice::ProcessPrx& proxy, const ::Ice::Context& context, const ::Ice::Callback_LocatorRegistry_setServerProcessProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setServerProcessProxy(id, proxy, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setServerProcessProxy.
     * @param result The asynchronous result object for the invocation.
     * @throws Ice::ServerNotFoundException Raised if the server cannot
     * be found.
     */
    ICE_MEMBER(ICE_API) void end_setServerProcessProxy(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setServerProcessProxy(const ::std::string&, const ::Ice::ProcessPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) LocatorFinder : public virtual ::Ice::Proxy<LocatorFinder, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The locator proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::LocatorPrx getLocator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLocator(_iceI_begin_getLocator(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLocator(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(context, cb, cookie);
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Callback_LocatorFinder_getLocatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLocator(const ::Ice::Context& context, const ::Ice::Callback_LocatorFinder_getLocatorPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocator(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLocator.
     * @param result The asynchronous result object for the invocation.
     * @return The locator proxy.
     */
    ICE_MEMBER(ICE_API) ::Ice::LocatorPrx end_getLocator(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getLocator(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Ice
{

/**
 * The Ice locator interface. This interface is used by clients to
 * lookup adapters and objects. It is also used by servers to get the
 * locator registry proxy.
 *
 * <p class="Note">The {@link Locator} interface is intended to be used by
 * Ice internals and by locator implementations. Regular user code
 * should not attempt to use any functionality of this interface
 * directly.
 * \headerfile Ice/Ice.h
 */
class ICE_API Locator : public virtual Object
{
public:

    typedef LocatorPrx ProxyType;
    typedef LocatorPtr PointerType;

    virtual ~Locator();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Find an object by identity and return a proxy that contains
     * the adapter ID or endpoints which can be used to access the
     * object.
     * @param cb The AMD callback object for the invocation.
     * @param id The identity.
     * @param current The Current object for the invocation.
     * @throws Ice::ObjectNotFoundException Raised if the object cannot
     * be found.
     */
    virtual void findObjectById_async(const ::Ice::AMD_Locator_findObjectByIdPtr& cb, const Identity& id, const Current& current = emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Find an adapter by id and return a proxy that contains
     * its endpoints.
     * @param cb The AMD callback object for the invocation.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot be
     * found.
     */
    virtual void findAdapterById_async(const ::Ice::AMD_Locator_findAdapterByIdPtr& cb, const ::std::string& id, const Current& current = emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_findAdapterById(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the locator registry.
     * @param current The Current object for the invocation.
     * @return The locator registry.
     */
    virtual LocatorRegistryPrx getRegistry(const Current& current = emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

/**
 * The Ice locator registry interface. This interface is used by
 * servers to register adapter endpoints with the locator.
 *
 * <p class="Note"> The {@link LocatorRegistry} interface is intended to be used
 * by Ice internals and by locator implementations. Regular user
 * code should not attempt to use any functionality of this interface
 * directly.
 * \headerfile Ice/Ice.h
 */
class ICE_API LocatorRegistry : public virtual Object
{
public:

    typedef LocatorRegistryPrx ProxyType;
    typedef LocatorRegistryPtr PointerType;

    virtual ~LocatorRegistry();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Set the adapter endpoints with the locator registry.
     * @param cb The AMD callback object for the invocation.
     * @param id The adapter id.
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param current The Current object for the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     */
    virtual void setAdapterDirectProxy_async(const ::Ice::AMD_LocatorRegistry_setAdapterDirectProxyPtr& cb, const ::std::string& id, const ObjectPrx& proxy, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the adapter endpoints with the locator registry.
     * @param cb The AMD callback object for the invocation.
     * @param adapterId The adapter id.
     * @param replicaGroupId The replica group id.
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     * @param current The Current object for the invocation.
     * @throws Ice::AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     * @throws Ice::AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     * @throws Ice::InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     */
    virtual void setReplicatedAdapterDirectProxy_async(const ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxyPtr& cb, const ::std::string& adapterId, const ::std::string& replicaGroupId, const ObjectPrx& p, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setReplicatedAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the process proxy for a server.
     * @param cb The AMD callback object for the invocation.
     * @param id The server id.
     * @param proxy The process proxy.
     * @param current The Current object for the invocation.
     * @throws Ice::ServerNotFoundException Raised if the server cannot
     * be found.
     */
    virtual void setServerProcessProxy_async(const ::Ice::AMD_LocatorRegistry_setServerProcessProxyPtr& cb, const ::std::string& id, const ProcessPrx& proxy, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setServerProcessProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const LocatorRegistry& lhs, const LocatorRegistry& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const LocatorRegistry& lhs, const LocatorRegistry& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

/**
 * This inferface should be implemented by services implementing the
 * Ice::Locator interface. It should be advertised through an Ice
 * object with the identity `Ice/LocatorFinder'. This allows clients
 * to retrieve the locator proxy with just the endpoint information of
 * the service.
 * \headerfile Ice/Ice.h
 */
class ICE_API LocatorFinder : public virtual Object
{
public:

    typedef LocatorFinderPrx ProxyType;
    typedef LocatorFinderPtr PointerType;

    virtual ~LocatorFinder();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the locator proxy implemented by the process hosting this
     * finder object. The proxy might point to several replicas.
     * @param current The Current object for the invocation.
     * @return The locator proxy.
     */
    virtual LocatorPrx getLocator(const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getLocator(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const LocatorFinder& lhs, const LocatorFinder& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const LocatorFinder& lhs, const LocatorFinder& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Ice::AdapterNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::InvalidReplicaGroupIdException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::AdapterAlreadyActiveException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::ObjectNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::Ice::ServerNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace Ice
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::Locator::begin_findObjectById.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_findObjectById.
 */
template<class T>
class CallbackNC_Locator_findObjectById : public Callback_Locator_findObjectById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ObjectPrx&);

    CallbackNC_Locator_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findObjectById.
 */
template<class T> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findObjectById.
 */
template<class T> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(T* instance, void (T::*cb)(const ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::Locator::begin_findObjectById.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_findObjectById.
 */
template<class T, typename CT>
class Callback_Locator_findObjectById : public Callback_Locator_findObjectById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ObjectPrx&, const CT&);

    Callback_Locator_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findObjectById.
 */
template<class T, typename CT> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findObjectById.
 */
template<class T, typename CT> Callback_Locator_findObjectByIdPtr
newCallback_Locator_findObjectById(T* instance, void (T::*cb)(const ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::Locator::begin_findAdapterById.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_findAdapterById.
 */
template<class T>
class CallbackNC_Locator_findAdapterById : public Callback_Locator_findAdapterById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ObjectPrx&);

    CallbackNC_Locator_findAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        ObjectPrx ret;
        try
        {
            ret = proxy->end_findAdapterById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findAdapterById.
 */
template<class T> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findAdapterById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findAdapterById.
 */
template<class T> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(T* instance, void (T::*cb)(const ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_findAdapterById<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::Locator::begin_findAdapterById.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_findAdapterById.
 */
template<class T, typename CT>
class Callback_Locator_findAdapterById : public Callback_Locator_findAdapterById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ObjectPrx&, const CT&);

    Callback_Locator_findAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        ObjectPrx ret;
        try
        {
            ret = proxy->end_findAdapterById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findAdapterById.
 */
template<class T, typename CT> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findAdapterById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_findAdapterById.
 */
template<class T, typename CT> Callback_Locator_findAdapterByIdPtr
newCallback_Locator_findAdapterById(T* instance, void (T::*cb)(const ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_findAdapterById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::Locator::begin_getRegistry.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_getRegistry.
 */
template<class T>
class CallbackNC_Locator_getRegistry : public Callback_Locator_getRegistry_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LocatorRegistryPrx&);

    CallbackNC_Locator_getRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        LocatorRegistryPrx ret;
        try
        {
            ret = proxy->end_getRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_getRegistry.
 */
template<class T> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const LocatorRegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getRegistry<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_getRegistry.
 */
template<class T> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(T* instance, void (T::*cb)(const LocatorRegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getRegistry<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::Locator::begin_getRegistry.
 * Create a wrapper instance by calling ::Ice::newCallback_Locator_getRegistry.
 */
template<class T, typename CT>
class Callback_Locator_getRegistry : public Callback_Locator_getRegistry_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LocatorRegistryPrx&, const CT&);

    Callback_Locator_getRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorPrx proxy = LocatorPrx::uncheckedCast(result->getProxy());
        LocatorRegistryPrx ret;
        try
        {
            ret = proxy->end_getRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_getRegistry.
 */
template<class T, typename CT> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const LocatorRegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getRegistry<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::Locator::begin_getRegistry.
 */
template<class T, typename CT> Callback_Locator_getRegistryPtr
newCallback_Locator_getRegistry(T* instance, void (T::*cb)(const LocatorRegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getRegistry<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setAdapterDirectProxy.
 */
template<class T>
class CallbackNC_LocatorRegistry_setAdapterDirectProxy : public Callback_LocatorRegistry_setAdapterDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LocatorRegistry_setAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorRegistryPrx proxy = LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setAdapterDirectProxy.
 */
template<class T, typename CT>
class Callback_LocatorRegistry_setAdapterDirectProxy : public Callback_LocatorRegistry_setAdapterDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LocatorRegistry_setAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorRegistryPrx proxy = LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setAdapterDirectProxyPtr
newCallback_LocatorRegistry_setAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy.
 */
template<class T>
class CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy : public Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorRegistryPrx proxy = LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setReplicatedAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setReplicatedAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy.
 */
template<class T, typename CT>
class Callback_LocatorRegistry_setReplicatedAdapterDirectProxy : public Callback_LocatorRegistry_setReplicatedAdapterDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LocatorRegistry_setReplicatedAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorRegistryPrx proxy = LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setReplicatedAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setReplicatedAdapterDirectProxyPtr
newCallback_LocatorRegistry_setReplicatedAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setReplicatedAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setServerProcessProxy.
 */
template<class T>
class CallbackNC_LocatorRegistry_setServerProcessProxy : public Callback_LocatorRegistry_setServerProcessProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LocatorRegistry_setServerProcessProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorRegistryPrx proxy = LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setServerProcessProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorRegistry_setServerProcessProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorRegistry_setServerProcessProxy.
 */
template<class T, typename CT>
class Callback_LocatorRegistry_setServerProcessProxy : public Callback_LocatorRegistry_setServerProcessProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LocatorRegistry_setServerProcessProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorRegistryPrx proxy = LocatorRegistryPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setServerProcessProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy.
 */
template<class T, typename CT> Callback_LocatorRegistry_setServerProcessProxyPtr
newCallback_LocatorRegistry_setServerProcessProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorRegistry_setServerProcessProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LocatorFinder::begin_getLocator.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorFinder_getLocator.
 */
template<class T>
class CallbackNC_LocatorFinder_getLocator : public Callback_LocatorFinder_getLocator_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LocatorPrx&);

    CallbackNC_LocatorFinder_getLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorFinderPrx proxy = LocatorFinderPrx::uncheckedCast(result->getProxy());
        LocatorPrx ret;
        try
        {
            ret = proxy->end_getLocator(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorFinder::begin_getLocator.
 */
template<class T> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(const LocatorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorFinder_getLocator<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorFinder::begin_getLocator.
 */
template<class T> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(T* instance, void (T::*cb)(const LocatorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LocatorFinder_getLocator<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LocatorFinder::begin_getLocator.
 * Create a wrapper instance by calling ::Ice::newCallback_LocatorFinder_getLocator.
 */
template<class T, typename CT>
class Callback_LocatorFinder_getLocator : public Callback_LocatorFinder_getLocator_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LocatorPrx&, const CT&);

    Callback_LocatorFinder_getLocator(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LocatorFinderPrx proxy = LocatorFinderPrx::uncheckedCast(result->getProxy());
        LocatorPrx ret;
        try
        {
            ret = proxy->end_getLocator(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorFinder::begin_getLocator.
 */
template<class T, typename CT> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(const IceUtil::Handle<T>& instance, void (T::*cb)(const LocatorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorFinder_getLocator<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LocatorFinder::begin_getLocator.
 */
template<class T, typename CT> Callback_LocatorFinder_getLocatorPtr
newCallback_LocatorFinder_getLocator(T* instance, void (T::*cb)(const LocatorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LocatorFinder_getLocator<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
