/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class StringParsers$ {
    public static final StringParsers$ MODULE$ = new StringParsers$();

    private final int intOverflowBoundary() {
        return -214748364;
    }

    private final int intOverflowDigit() {
        return 9;
    }

    private final long longOverflowBoundary() {
        return -922337203685477580L;
    }

    private final int longOverflowDigit() {
        return 9;
    }

    private final int decValue(char ch) {
        return Character.digit(ch, 10);
    }

    private final Option<Object> stepToOverflow(String from, int len, int agg, boolean isPositive, int min) {
        return this.rec$1(1, agg, min, len, isPositive, from);
    }

    private final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public final Option<Object> parseBool(String from) {
        return from.equalsIgnoreCase("true") ? new Some<Boolean>(BoxesRunTime.boxToBoolean(true)) : (from.equalsIgnoreCase("false") ? new Some<Boolean>(BoxesRunTime.boxToBoolean(false)) : None$.MODULE$);
    }

    public final Option<Object> parseByte(String from) {
        Option option;
        int len = from.length();
        if (len == 0) {
            option = None$.MODULE$;
        } else {
            char first = from.charAt(0);
            int v = this.decValue(first);
            option = len == 1 ? (v > -1 ? new Some<Byte>(BoxesRunTime.boxToByte((byte)v)) : None$.MODULE$) : (v > -1 ? this.stepToOverflow(from, len, -v, true, -128).map((Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToByte(StringParsers$.$anonfun$parseByte$1(BoxesRunTime.unboxToInt(x$1)))) : (first == '+' ? this.stepToOverflow(from, len, 0, true, -128).map((Function1<Object, Object> & Serializable)x$2 -> BoxesRunTime.boxToByte(StringParsers$.$anonfun$parseByte$2(BoxesRunTime.unboxToInt(x$2)))) : (first == '-' ? this.stepToOverflow(from, len, 0, false, -128).map((Function1<Object, Object> & Serializable)x$3 -> BoxesRunTime.boxToByte(StringParsers$.$anonfun$parseByte$3(BoxesRunTime.unboxToInt(x$3)))) : None$.MODULE$)));
        }
        return option;
    }

    public final Option<Object> parseShort(String from) {
        Option option;
        int len = from.length();
        if (len == 0) {
            option = None$.MODULE$;
        } else {
            char first = from.charAt(0);
            int v = this.decValue(first);
            option = len == 1 ? (v > -1 ? new Some<Short>(BoxesRunTime.boxToShort((short)v)) : None$.MODULE$) : (v > -1 ? this.stepToOverflow(from, len, -v, true, Short.MIN_VALUE).map((Function1<Object, Object> & Serializable)x$4 -> BoxesRunTime.boxToShort(StringParsers$.$anonfun$parseShort$1(BoxesRunTime.unboxToInt(x$4)))) : (first == '+' ? this.stepToOverflow(from, len, 0, true, Short.MIN_VALUE).map((Function1<Object, Object> & Serializable)x$5 -> BoxesRunTime.boxToShort(StringParsers$.$anonfun$parseShort$2(BoxesRunTime.unboxToInt(x$5)))) : (first == '-' ? this.stepToOverflow(from, len, 0, false, Short.MIN_VALUE).map((Function1<Object, Object> & Serializable)x$6 -> BoxesRunTime.boxToShort(StringParsers$.$anonfun$parseShort$3(BoxesRunTime.unboxToInt(x$6)))) : None$.MODULE$)));
        }
        return option;
    }

    public final Option<Object> parseInt(String from) {
        Option option;
        int len = from.length();
        if (len == 0) {
            option = None$.MODULE$;
        } else {
            char first = from.charAt(0);
            int v = this.decValue(first);
            option = len == 1 ? (v > -1 ? new Some<Integer>(BoxesRunTime.boxToInteger(v)) : None$.MODULE$) : (v > -1 ? this.step$1(1, -v, true, len, from) : (first == '+' ? this.step$1(1, 0, true, len, from) : (first == '-' ? this.step$1(1, 0, false, len, from) : None$.MODULE$)));
        }
        return option;
    }

    public final Option<Object> parseLong(String from) {
        Option option;
        int len = from.length();
        if (len == 0) {
            option = None$.MODULE$;
        } else {
            char first = from.charAt(0);
            long v = this.decValue(first);
            option = len == 1 ? (v > -1L ? new Some<Long>(BoxesRunTime.boxToLong(v)) : None$.MODULE$) : (v > -1L ? this.step$2(1, -v, true, len, from) : (first == '+' ? this.step$2(1, 0L, true, len, from) : (first == '-' ? this.step$2(1, 0L, false, len, from) : None$.MODULE$)));
        }
        return option;
    }

    public final boolean checkFloatFormat(String format) {
        boolean bl;
        String qual$1 = Predef$.MODULE$.augmentString(format);
        Function1<Object, Object> & Serializable x$1 = (Function1<Object, Object> & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.$anonfun$checkFloatFormat$12(BoxesRunTime.unboxToChar(ch)));
        int x$2 = StringOps$.MODULE$.indexWhere$default$2$extension(qual$1);
        int unspacedStart = StringOps$.MODULE$.indexWhere$extension(qual$1, x$1, x$2);
        String qual$2 = Predef$.MODULE$.augmentString(format);
        Function1<Object, Object> & Serializable x$3 = (Function1<Object, Object> & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.$anonfun$checkFloatFormat$13(BoxesRunTime.unboxToChar(ch)));
        int x$4 = StringOps$.MODULE$.lastIndexWhere$default$2$extension(qual$2);
        int unspacedEnd = StringOps$.MODULE$.lastIndexWhere$extension(qual$2, x$3, x$4) + 1;
        if (unspacedStart == -1 || unspacedStart >= unspacedEnd || unspacedEnd <= 0) {
            bl = false;
        } else {
            int unsigned;
            char startchar = format.charAt(unspacedStart);
            int n = unsigned = startchar == '-' || startchar == '+' ? unspacedStart + 1 : unspacedStart;
            if (unsigned >= unspacedEnd) {
                bl = false;
            } else if (format.charAt(unsigned) == 'N') {
                String string = format.substring(unsigned, unspacedEnd);
                String string2 = "NaN";
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            } else if (format.charAt(unsigned) == 'I') {
                String string = format.substring(unsigned, unspacedEnd);
                String string3 = "Infinity";
                bl = !(string != null ? !string.equals(string3) : string3 != null);
            } else {
                char endchar = format.charAt(unspacedEnd - 1);
                int desuffixed = endchar == 'f' || endchar == 'F' || endchar == 'd' || endchar == 'D' ? unspacedEnd - 1 : unspacedEnd;
                int len = desuffixed - unsigned;
                bl = len <= 0 ? false : (len >= 2 && (format.charAt(unsigned + 1) == 'x' || format.charAt(unsigned + 1) == 'X') ? format.charAt(unsigned) == '0' && this.isHexFloatLiteral$1(unsigned + 2, desuffixed, format) : this.isDecFloatLiteral$1(unsigned, desuffixed, format));
            }
        }
        return bl;
    }

    public Option<Object> parseFloat(String from) {
        return this.checkFloatFormat(from) ? new Some<Float>(BoxesRunTime.boxToFloat(Float.parseFloat(from))) : None$.MODULE$;
    }

    public Option<Object> parseDouble(String from) {
        return this.checkFloatFormat(from) ? new Some<Double>(BoxesRunTime.boxToDouble(Double.parseDouble(from))) : None$.MODULE$;
    }

    private final Option rec$1(int i, int agg, int min$1, int len$1, boolean isPositive$1, String from$1) {
        Option option;
        while (true) {
            if (agg < min$1) {
                option = None$.MODULE$;
                break;
            }
            if (i == len$1) {
                if (!isPositive$1) {
                    option = new Some<Integer>(BoxesRunTime.boxToInteger(agg));
                    break;
                }
                if (agg == min$1) {
                    option = None$.MODULE$;
                    break;
                }
                option = new Some<Integer>(BoxesRunTime.boxToInteger(-agg));
                break;
            }
            int digit = this.decValue(from$1.charAt(i));
            if (digit == -1) {
                option = None$.MODULE$;
                break;
            }
            agg = agg * 10 - digit;
            ++i;
        }
        return option;
    }

    public static final /* synthetic */ byte $anonfun$parseByte$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$parseByte$2(int x$2) {
        return (byte)x$2;
    }

    public static final /* synthetic */ byte $anonfun$parseByte$3(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ short $anonfun$parseShort$1(int x$4) {
        return (short)x$4;
    }

    public static final /* synthetic */ short $anonfun$parseShort$2(int x$5) {
        return (short)x$5;
    }

    public static final /* synthetic */ short $anonfun$parseShort$3(int x$6) {
        return (short)x$6;
    }

    private final Option step$1(int i, int agg, boolean isPositive, int len$2, String from$2) {
        Option option;
        while (true) {
            if (i == len$2) {
                if (!isPositive) {
                    option = new Some<Integer>(BoxesRunTime.boxToInteger(agg));
                    break;
                }
                if (agg == Integer.MIN_VALUE) {
                    option = None$.MODULE$;
                    break;
                }
                option = new Some<Integer>(BoxesRunTime.boxToInteger(-agg));
                break;
            }
            if (agg < -214748364) {
                option = None$.MODULE$;
                break;
            }
            int digit = this.decValue(from$2.charAt(i));
            if (digit == -1 || agg == -214748364 && digit == 9) {
                option = None$.MODULE$;
                break;
            }
            agg = agg * 10 - digit;
            ++i;
        }
        return option;
    }

    private final Option step$2(int i, long agg, boolean isPositive, int len$3, String from$3) {
        Option option;
        while (true) {
            if (i == len$3) {
                if (isPositive && agg == Long.MIN_VALUE) {
                    option = None$.MODULE$;
                    break;
                }
                if (isPositive) {
                    option = new Some<Long>(BoxesRunTime.boxToLong(-agg));
                    break;
                }
                option = new Some<Long>(BoxesRunTime.boxToLong(agg));
                break;
            }
            if (agg < -922337203685477580L) {
                option = None$.MODULE$;
                break;
            }
            int digit = this.decValue(from$3.charAt(i));
            if (digit == -1 || agg == -922337203685477580L && digit == 9) {
                option = None$.MODULE$;
                break;
            }
            agg = agg * 10L - (long)digit;
            ++i;
        }
        return option;
    }

    private final boolean rec$2(int i, int end$1, Function1 pred$1, String format$1) {
        boolean bl;
        block3: {
            block2: {
                while (i < end$1) {
                    if (BoxesRunTime.unboxToBoolean(pred$1.apply(BoxesRunTime.boxToCharacter(format$1.charAt(i))))) {
                        ++i;
                        continue;
                    }
                    break block2;
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean forAllBetween$1(int start, int end, Function1 pred, String format$1) {
        return this.rec$2(start, end, pred, format$1);
    }

    private final int rec$3(int i, int until$1, Function1 predicate$1, String format$1) {
        while (i < until$1 && BoxesRunTime.unboxToBoolean(predicate$1.apply(BoxesRunTime.boxToCharacter(format$1.charAt(i))))) {
            ++i;
        }
        return i;
    }

    private final int skipIndexWhile$1(Function1 predicate, int from, int until, String format$1) {
        return this.rec$3(from, until, predicate, format$1);
    }

    private static final boolean isHexDigit$1(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean prefixOK$1(int startIndex, int endIndex, String format$1) {
        int len = endIndex - startIndex;
        if (len <= 0) return false;
        if (format$1.charAt(startIndex) == '.') {
            if (len <= 1) return false;
            if (!this.forAllBetween$1(startIndex + 1, endIndex, (Function1<Object, Object> & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.isHexDigit$1(BoxesRunTime.unboxToChar(ch))), format$1)) return false;
            return true;
        }
        int noLeading = this.skipIndexWhile$1((Function1<Object, Object> & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.isHexDigit$1(BoxesRunTime.unboxToChar(ch))), startIndex, endIndex, format$1);
        if (noLeading >= endIndex) return true;
        if (format$1.charAt(noLeading) != '.') return false;
        if (!this.forAllBetween$1(noLeading + 1, endIndex, (Function1<Object, Object> & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.isHexDigit$1(BoxesRunTime.unboxToChar(ch))), format$1)) return false;
        return true;
    }

    private final boolean postfixOK$1(int startIndex, int endIndex, String format$1) {
        char startchar;
        return startIndex < endIndex && (this.forAllBetween$1(startIndex, endIndex, (Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), format$1) || ((startchar = format$1.charAt(startIndex)) == '+' || startchar == '-') && endIndex - startIndex > 1 && this.forAllBetween$1(startIndex + 1, endIndex, (Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), format$1));
    }

    public static final /* synthetic */ boolean $anonfun$checkFloatFormat$6(char ch) {
        return ch == 'p' || ch == 'P';
    }

    private final boolean isHexFloatLiteral$1(int startIndex, int endIndex, String format$1) {
        int pIndex = StringOps$.MODULE$.indexWhere$extension(Predef$.MODULE$.augmentString(format$1), (Function1<Object, Object> & Serializable)ch -> BoxesRunTime.boxToBoolean(StringParsers$.$anonfun$checkFloatFormat$6(BoxesRunTime.unboxToChar(ch))), startIndex);
        return pIndex <= endIndex && this.prefixOK$1(startIndex, pIndex, format$1) && this.postfixOK$1(pIndex + 1, endIndex, format$1);
    }

    private static final boolean isExp$1(char c) {
        return c == 'e' || c == 'E';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean expOK$1(int startIndex, int endIndex, String format$1) {
        if (startIndex >= endIndex) return false;
        char startChar = format$1.charAt(startIndex);
        if (startChar == '+' || startChar == '-') {
            if (endIndex <= startIndex + 1) return false;
            if (this.skipIndexWhile$1((Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex + 1, endIndex, format$1) != endIndex) return false;
            return true;
        }
        if (this.skipIndexWhile$1((Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex, endIndex, format$1) != endIndex) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDecFloatLiteral$1(int startIndex, int endIndex, String format$1) {
        char startChar = format$1.charAt(startIndex);
        if (startChar == '.') {
            int noSignificant = this.skipIndexWhile$1((Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex + 1, endIndex, format$1);
            if (noSignificant <= startIndex + 1) return false;
            if (noSignificant >= endIndex) return true;
            if (!StringParsers$.isExp$1(format$1.charAt(noSignificant))) return false;
            if (!this.expOK$1(noSignificant + 1, endIndex, format$1)) return false;
            return true;
        }
        if (!this.isDigit(startChar)) return false;
        int noInt = this.skipIndexWhile$1((Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), startIndex, endIndex, format$1);
        if (noInt == endIndex) return true;
        if (format$1.charAt(noInt) == '.') {
            int noSignificant = this.skipIndexWhile$1((Function1<Object, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))), noInt + 1, endIndex, format$1);
            if (noSignificant >= endIndex) return true;
            if (!StringParsers$.isExp$1(format$1.charAt(noSignificant))) return false;
            if (!this.expOK$1(noSignificant + 1, endIndex, format$1)) return false;
            return true;
        }
        if (!StringParsers$.isExp$1(format$1.charAt(noInt))) return false;
        if (!this.expOK$1(noInt + 1, endIndex, format$1)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkFloatFormat$12(char ch) {
        return ch > ' ';
    }

    public static final /* synthetic */ boolean $anonfun$checkFloatFormat$13(char ch) {
        return ch > ' ';
    }

    private StringParsers$() {
    }
}

