/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeInsertHandler
implements InsertHandler<LookupElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.XmlAttributeInsertHandler");
    public static final XmlAttributeInsertHandler INSTANCE = new XmlAttributeInsertHandler();
    private final String myNamespaceToInsert;

    public XmlAttributeInsertHandler() {
        this(null);
    }

    public XmlAttributeInsertHandler(@Nullable String namespaceToInsert) {
        this.myNamespaceToInsert = namespaceToInsert;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        boolean hasQuotes;
        if (context == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        PsiFile file = context.getFile();
        CharSequence chars = document.getCharsSequence();
        String quote = XmlEditUtil.getAttributeQuote(file);
        boolean insertQuotes = WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && StringUtil.isNotEmpty((String)quote);
        boolean bl = hasQuotes = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='");
        if (!hasQuotes) {
            if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=")) {
                document.deleteString(caretOffset, caretOffset + 1);
            }
            PsiElement fileContext = file.getContext();
            String toInsert = null;
            if (fileContext != null) {
                if (fileContext.getText().startsWith("\"")) {
                    toInsert = "=''";
                }
                if (fileContext.getText().startsWith("'")) {
                    toInsert = "=\"\"";
                }
            }
            if (toInsert == null) {
                toInsert = "=" + quote + quote;
            }
            if (!insertQuotes) {
                toInsert = "=";
            }
            if (caretOffset < document.getTextLength() && "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                document.insertString(caretOffset, (CharSequence)(toInsert + " "));
            } else {
                document.insertString(caretOffset, (CharSequence)toInsert);
            }
            if ('=' == context.getCompletionChar()) {
                context.setAddCompletionChar(false);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset + (insertQuotes || hasQuotes ? 2 : 1));
        TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(context.getEditor());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        AutoPopupController.getInstance((Project)editor.getProject()).scheduleAutoPopup(editor);
        if (this.myNamespaceToInsert != null && file instanceof XmlFile) {
            String prefix;
            XmlTag tag;
            PsiElement element = file.findElementAt(context.getStartOffset());
            XmlTag xmlTag = tag = element != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) : null;
            if (tag != null && (prefix = ExtendedTagInsertHandler.suggestPrefix((XmlFile)file, this.myNamespaceToInsert)) != null) {
                prefix = XmlAttributeInsertHandler.makePrefixUnique(prefix, tag);
                XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper(context.getFile());
                if (helper != null) {
                    Project project = context.getProject();
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    XmlAttributeInsertHandler.qualifyWithPrefix(prefix, element);
                    helper.insertNamespaceDeclaration((XmlFile)file, editor, Collections.singleton(this.myNamespaceToInsert), prefix, null);
                }
            }
        }
    }

    private static void qualifyWithPrefix(@NotNull String namespacePrefix, @NotNull PsiElement context) {
        XmlAttribute attribute;
        String prefix;
        PsiElement parent;
        if (namespacePrefix == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(3);
        }
        if ((parent = context.getParent()) instanceof XmlAttribute && !(prefix = (attribute = (XmlAttribute)parent).getNamespacePrefix()).equals(namespacePrefix) && StringUtil.isNotEmpty((String)namespacePrefix)) {
            String name = namespacePrefix + ":" + attribute.getLocalName();
            try {
                attribute.setName(name);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static String makePrefixUnique(@NotNull String basePrefix, @NotNull XmlTag context) {
        if (basePrefix == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(5);
        }
        if (context.getNamespaceByPrefix(basePrefix).isEmpty()) {
            String string = basePrefix;
            if (string == null) {
                XmlAttributeInsertHandler.$$$reportNull$$$0(6);
            }
            return string;
        }
        int i = 1;
        while (!context.getNamespaceByPrefix(basePrefix + i).isEmpty()) {
            ++i;
        }
        String string = basePrefix + i;
        if (string == null) {
            XmlAttributeInsertHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePrefix";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/XmlAttributeInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/XmlAttributeInsertHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "makePrefixUnique";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "qualifyWithPrefix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makePrefixUnique";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

