/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import org.jetbrains.annotations.NotNull;

public class DocumentMarkupModelManager {
    private static final Logger LOG = Logger.getInstance(DocumentMarkupModelManager.class);
    private final WeakList<Document> myDocumentSet;
    private volatile boolean myDisposed;

    public static DocumentMarkupModelManager getInstance(Project project) {
        return (DocumentMarkupModelManager)project.getComponent(DocumentMarkupModelManager.class);
    }

    public DocumentMarkupModelManager(final @NotNull Project project) {
        if (project == null) {
            DocumentMarkupModelManager.$$$reportNull$$$0(0);
        }
        this.myDocumentSet = new WeakList();
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DocumentMarkupModelManager.this.cleanupProjectMarkups(project);
            }
        });
    }

    public void registerDocument(Document document) {
        LOG.assertTrue(!this.myDisposed);
        this.myDocumentSet.add((Object)document);
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private void cleanupProjectMarkups(@NotNull Project project) {
        if (project == null) {
            DocumentMarkupModelManager.$$$reportNull$$$0(1);
        }
        if (!this.myDisposed) {
            this.myDisposed = true;
            for (Document document : this.myDocumentSet.toStrongList()) {
                DocumentMarkupModel.removeMarkupModel(document, project);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/editor/impl/DocumentMarkupModelManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanupProjectMarkups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

