/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCompleteMacro
extends Macro {
    private final String myName;
    private final boolean myCheckCompletionChar;

    protected BaseCompleteMacro(@NonNls String name) {
        this(name, true);
    }

    protected BaseCompleteMacro(@NonNls String name, boolean checkCompletionChar) {
        this.myName = name;
        this.myCheckCompletionChar = checkCompletionChar;
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.myName + "()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            BaseCompleteMacro.$$$reportNull$$$0(0);
        }
        return "a";
    }

    public final Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            BaseCompleteMacro.$$$reportNull$$$0(1);
        }
        return new InvokeActionResult(() -> this.invokeCompletion(context));
    }

    private void invokeCompletion(ExpressionContext context) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        PsiFile psiFile = editor != null ? PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project) : null;
        Runnable runnable2 = () -> {
            if (project.isDisposed() || editor == null || editor.isDisposed() || psiFile == null || !psiFile.isValid()) {
                return;
            }
            if (CompletionServiceImpl.getCompletionService().getCurrentCompletion() != null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                this.invokeCompletionHandler(project, editor);
                LookupEx lookup = LookupManager.getInstance(project).getActiveLookup();
                if (lookup != null) {
                    lookup.addLookupListener(new MyLookupListener(context, this.myCheckCompletionChar));
                }
            }, "", null);
        };
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    protected abstract void invokeCompletionHandler(Project var1, Editor var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/macro/BaseCompleteMacro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/macro/BaseCompleteMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLookupListener
    implements LookupListener {
        private final ExpressionContext myContext;
        private final boolean myCheckCompletionChar;

        MyLookupListener(@NotNull ExpressionContext context, boolean checkCompletionChar) {
            if (context == null) {
                MyLookupListener.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            this.myCheckCompletionChar = checkCompletionChar;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            LookupElement item;
            if (event == null) {
                MyLookupListener.$$$reportNull$$$0(1);
            }
            if ((item = event.getItem()) == null) {
                return;
            }
            char c2 = event.getCompletionChar();
            if (this.myCheckCompletionChar && !LookupEvent.isSpecialCompletionChar((char)c2)) {
                return;
            }
            Project project = this.myContext.getProject();
            if (project == null) {
                return;
            }
            Runnable runnable2 = () -> WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                TemplateState templateState;
                Editor editor = this.myContext.getEditor();
                if (editor != null && (templateState = TemplateManagerImpl.getTemplateState(editor)) != null) {
                    templateState.considerNextTabOnLookupItemSelected(item);
                }
            });
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.current(), project.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

