/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.schema.YamlArrayAdapter;
import org.jetbrains.yaml.schema.YamlEmptyObjectAdapter;
import org.jetbrains.yaml.schema.YamlEmptyValueAdapter;
import org.jetbrains.yaml.schema.YamlGenericValueAdapter;
import org.jetbrains.yaml.schema.YamlObjectAdapter;
import org.jetbrains.yaml.schema.YamlPropertyKeyAdapter;

public class YamlPropertyAdapter
implements JsonPropertyAdapter {
    private final PsiElement myProperty;

    public YamlPropertyAdapter(@NotNull PsiElement property) {
        if (property == null) {
            YamlPropertyAdapter.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
    }

    @Nullable
    public String getName() {
        return this.myProperty instanceof YAMLKeyValue ? ((YAMLKeyValue)this.myProperty).getKeyText() : this.myProperty.getText();
    }

    @Nullable
    public JsonValueAdapter getNameValueAdapter() {
        if (!(this.myProperty instanceof YAMLKeyValue)) {
            return null;
        }
        PsiElement key = ((YAMLKeyValue)this.myProperty).getKey();
        if (key == null) {
            return null;
        }
        return new YamlPropertyKeyAdapter(key);
    }

    @NotNull
    public Collection<JsonValueAdapter> getValues() {
        YAMLValue value = this.myProperty instanceof YAMLKeyValue ? ((YAMLKeyValue)this.myProperty).getValue() : null;
        List list = value != null ? Collections.singletonList(YamlPropertyAdapter.createValueAdapterByType(value)) : ContainerUtil.createMaybeSingletonList((Object)YamlPropertyAdapter.createEmptyValueAdapter(this.myProperty, false));
        if (list == null) {
            YamlPropertyAdapter.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public PsiElement getDelegate() {
        PsiElement psiElement = this.myProperty;
        if (psiElement == null) {
            YamlPropertyAdapter.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Nullable
    public JsonObjectValueAdapter getParentObject() {
        YAMLMapping parentMapping = this.myProperty instanceof YAMLKeyValue ? ((YAMLKeyValue)this.myProperty).getParentMapping() : (YAMLMapping)ObjectUtils.tryCast((Object)this.myProperty.getParent(), YAMLMapping.class);
        return parentMapping != null ? new YamlObjectAdapter(parentMapping) : null;
    }

    @NotNull
    public static JsonValueAdapter createValueAdapterByType(@NotNull YAMLValue value) {
        JsonValueAdapter adapter;
        PsiElement result;
        if (value == null) {
            YamlPropertyAdapter.$$$reportNull$$$0(3);
        }
        if (value instanceof YAMLAlias && (result = YamlObjectAdapter.resolveYamlAlias(value)) instanceof YAMLValue && (adapter = (JsonValueAdapter)RecursionManager.doPreventingRecursion((Object)value, (boolean)false, () -> YamlPropertyAdapter.createValueAdapterByType((YAMLValue)result))) != null) {
            JsonValueAdapter jsonValueAdapter = adapter;
            if (jsonValueAdapter == null) {
                YamlPropertyAdapter.$$$reportNull$$$0(4);
            }
            return jsonValueAdapter;
        }
        if (value instanceof YAMLMapping) {
            YamlObjectAdapter yamlObjectAdapter = new YamlObjectAdapter((YAMLMapping)value);
            if (yamlObjectAdapter == null) {
                YamlPropertyAdapter.$$$reportNull$$$0(5);
            }
            return yamlObjectAdapter;
        }
        if (value instanceof YAMLSequence) {
            YamlArrayAdapter yamlArrayAdapter = new YamlArrayAdapter((YAMLSequence)value);
            if (yamlArrayAdapter == null) {
                YamlPropertyAdapter.$$$reportNull$$$0(6);
            }
            return yamlArrayAdapter;
        }
        YamlGenericValueAdapter yamlGenericValueAdapter = new YamlGenericValueAdapter(value);
        if (yamlGenericValueAdapter == null) {
            YamlPropertyAdapter.$$$reportNull$$$0(7);
        }
        return yamlGenericValueAdapter;
    }

    @Nullable
    public static JsonValueAdapter createEmptyValueAdapter(@NotNull PsiElement context, boolean pinSelf) {
        PsiElement next;
        if (context == null) {
            YamlPropertyAdapter.$$$reportNull$$$0(8);
        }
        if (context instanceof YAMLKeyValue && ((YAMLKeyValue)context).getValue() == null && PsiUtilCore.getElementType((PsiElement)(next = PsiTreeUtil.skipWhitespacesForward((PsiElement)context))) == YAMLTokenTypes.EOL && PsiUtilCore.getElementType((PsiElement)(next = PsiTreeUtil.skipWhitespacesForward((PsiElement)next))) == YAMLTokenTypes.INDENT && !(PsiTreeUtil.skipWhitespacesForward((PsiElement)next) instanceof YAMLKeyValue)) {
            return new YamlEmptyObjectAdapter(next);
        }
        PsiElement nextSibling = context.getNextSibling();
        PsiElement nodeToHighlight = PsiUtilCore.getElementType((PsiElement)nextSibling) == TokenType.WHITE_SPACE ? nextSibling : (pinSelf ? context : context.getLastChild());
        return nodeToHighlight == null ? null : new YamlEmptyValueAdapter(nodeToHighlight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlPropertyAdapter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlPropertyAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueAdapterByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdapterByType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyValueAdapter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

