/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRenameBranchOperation
extends GitBranchOperation {
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final String myCurrentName;
    @NotNull
    private final String myNewName;

    public GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull String currentName, @NotNull String newName, @NotNull List<? extends GitRepository> repositories) {
        if (project == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(2);
        }
        if (currentName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(4);
        }
        if (repositories == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(5);
        }
        super(project, git, uiHandler, repositories);
        this.myCurrentName = currentName;
        this.myNewName = newName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.renameBranch(repository, this.myCurrentName, this.myNewName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                GitRenameBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError("Couldn't rename " + this.myCurrentName + " to " + this.myNewName, result2.getErrorOutputAsJoinedString());
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            result2.append(repository, this.myGit.renameBranch(repository, this.myNewName, this.myCurrentName, new GitLineHandlerListener[0]));
            GitRenameBranchOperation.refresh(repository);
        }
        if (result2.totalSuccess()) {
            this.myNotifier.notifySuccess("Rollback Successful", "Renamed back to " + this.myCurrentName);
        } else {
            this.myNotifier.notifyError("Rollback Failed", result2.getErrorOutputWithReposIndication());
        }
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        String string = String.format("Branch <b><code>%s</code></b> was renamed to <b><code>%s</code></b>", this.myCurrentName, this.myNewName);
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = "However rename has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (rename branch back to " + this.myCurrentName + ") not to let branches diverge.";
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        if ("rename" == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(8);
        }
        return "rename";
    }

    private static void refresh(@NotNull GitRepository repository) {
        if (repository == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(9);
        }
        repository.update();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitRenameBranchOperation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitRenameBranchOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

