/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.validation;

import com.intellij.stats.completion.DeserializedLogEvent;
import com.intellij.stats.completion.LogEventSerializer;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.validation.CompletionValidationState;
import com.intellij.stats.validation.EventLine;
import com.intellij.stats.validation.SessionValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0014\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/stats/validation/InputSessionValidator;", "", "sessionValidationResult", "Lcom/intellij/stats/validation/SessionValidationResult;", "(Lcom/intellij/stats/validation/SessionValidationResult;)V", "dumpSession", "", "session", "", "Lcom/intellij/stats/validation/EventLine;", "isValidSession", "", "errorMessage", "", "processCompletionSession", "validate", "input", "", "intellij.statsCollector.logEvents"})
public final class InputSessionValidator {
    private final SessionValidationResult sessionValidationResult;

    public final void validate(@NotNull Iterable<String> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        String currentSessionUid = null;
        boolean bl = false;
        List session = new ArrayList();
        for (String line : input) {
            CharSequence charSequence = line;
            boolean bl2 = false;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            bl2 = false;
            if (charSequence.length() == 0) continue;
            DeserializedLogEvent event = LogEventSerializer.INSTANCE.fromString(line);
            EventLine eventLine = new EventLine(event, line);
            if (Intrinsics.areEqual((Object)eventLine.getSessionUid(), (Object)currentSessionUid)) {
                session.add(eventLine);
                continue;
            }
            this.processCompletionSession(session);
            session.clear();
            currentSessionUid = eventLine.getSessionUid();
            session.add(eventLine);
        }
        this.processCompletionSession(session);
    }

    private final void processCompletionSession(List<EventLine> session) {
        boolean bl;
        block10: {
            if (session.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = session;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    EventLine it = (EventLine)element$iv;
                    boolean bl2 = false;
                    if (!(!it.isValid())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            this.dumpSession(session, false, "Event line is invalid");
            return;
        }
        boolean isValidSession = false;
        String errorMessage = "";
        EventLine initial = (EventLine)CollectionsKt.first(session);
        if (initial.getEvent() instanceof CompletionStartedEvent) {
            CompletionValidationState state = new CompletionValidationState((CompletionStartedEvent)initial.getEvent());
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)session, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EventLine it = (EventLine)element$iv;
                boolean bl3 = false;
                LogEvent logEvent = it.getEvent();
                if (logEvent == null) {
                    Intrinsics.throwNpe();
                }
                state.accept(logEvent);
            }
            isValidSession = state.isSessionValid();
            if (!isValidSession) {
                errorMessage = state.errorMessage();
            }
        } else {
            LogEvent logEvent = initial.getEvent();
            errorMessage = "Session starts with other event: " + (Object)((Object)(logEvent != null ? logEvent.getActionType() : null));
        }
        this.dumpSession(session, isValidSession, errorMessage);
    }

    private final void dumpSession(List<EventLine> session, boolean isValidSession, String errorMessage) {
        if (isValidSession) {
            this.sessionValidationResult.addValidSession(session);
        } else {
            this.sessionValidationResult.addErrorSession(session);
        }
    }

    public InputSessionValidator(@NotNull SessionValidationResult sessionValidationResult) {
        Intrinsics.checkParameterIsNotNull((Object)sessionValidationResult, (String)"sessionValidationResult");
        this.sessionValidationResult = sessionValidationResult;
    }
}

