/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.UserNameRegex;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.log.HgRefManager;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(HgLogProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public HgLogProvider(@NotNull Project project) {
        if (project == null) {
            HgLogProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRefSorter = new HgRefManager(project, (RepositoryManager<HgRepository>)HgLogProvider.getHgRepoManager(project));
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(1);
        }
        if (requirements == null) {
            HgLogProvider.$$$reportNull$$$0(2);
        }
        List<VcsCommitMetadata> commits = HgHistoryUtil.loadMetadata(this.myProject, root, requirements.getCommitCount(), Collections.emptyList());
        LogDataImpl logDataImpl = new LogDataImpl(this.readAllRefs(root), commits);
        if (logDataImpl == null) {
            HgLogProvider.$$$reportNull$$$0(3);
        }
        return logDataImpl;
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(4);
        }
        if (commitConsumer == null) {
            HgLogProvider.$$$reportNull$$$0(5);
        }
        HashSet userRegistry = new HashSet();
        List<TimedVcsCommit> commits = HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<? super VcsUser>)new CollectConsumer(userRegistry), Collections.emptyList());
        for (TimedVcsCommit commit : commits) {
            commitConsumer.consume((Object)commit);
        }
        LogDataImpl logDataImpl = new LogDataImpl(this.readAllRefs(root), userRegistry);
        if (logDataImpl == null) {
            HgLogProvider.$$$reportNull$$$0(6);
        }
        return logDataImpl;
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> commitConsumer) throws VcsException {
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(7);
        }
        if (hashes == null) {
            HgLogProvider.$$$reportNull$$$0(8);
        }
        if (commitConsumer == null) {
            HgLogProvider.$$$reportNull$$$0(9);
        }
        HgVcs hgvcs = HgVcs.getInstance(this.myProject);
        assert (hgvcs != null);
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, hgvcs.getVersion());
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(this.myProject);
        if (factory == null) {
            return;
        }
        HgFileRevisionLogParser parser = new HgFileRevisionLogParser(this.myProject, HgHistoryUtil.getOriginalHgFile(this.myProject, root), hgvcs.getVersion());
        HgHistoryUtil.readLog(this.myProject, root, hgvcs.getVersion(), -1, HgHistoryUtil.prepareHashes(hashes), HgChangesetUtil.makeTemplate(templates), (Consumer<? super StringBuilder>)((Consumer)stringBuilder -> {
            HgFileRevision revision = (HgFileRevision)parser.convert(stringBuilder.toString());
            if (revision != null) {
                commitConsumer.consume((Object)HgHistoryUtil.createDetails(this.myProject, root, factory, revision));
            }
        }));
    }

    @NotNull
    public List<? extends VcsCommitMetadata> readMetadata(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(10);
        }
        if (hashes == null) {
            HgLogProvider.$$$reportNull$$$0(11);
        }
        List<? extends VcsCommitMetadata> list = HgHistoryUtil.readCommitMetadata(this.myProject, root, hashes);
        if (list == null) {
            HgLogProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private Set<VcsRef> readAllRefs(@NotNull VirtualFile root) {
        String tipRevision;
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(13);
        }
        if (this.myProject.isDisposed()) {
            Set<VcsRef> set = Collections.emptySet();
            if (set == null) {
                HgLogProvider.$$$reportNull$$$0(14);
            }
            return set;
        }
        HgRepository repository = (HgRepository)HgLogProvider.getHgRepoManager(this.myProject).getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            Set<VcsRef> set = Collections.emptySet();
            if (set == null) {
                HgLogProvider.$$$reportNull$$$0(15);
            }
            return set;
        }
        repository.update();
        Map<String, LinkedHashSet<Hash>> branches = repository.getBranches();
        Set<String> openedBranchNames = repository.getOpenedBranches();
        Collection<HgNameWithHashInfo> bookmarks = repository.getBookmarks();
        Collection<HgNameWithHashInfo> tags = repository.getTags();
        Collection<HgNameWithHashInfo> localTags = repository.getLocalTags();
        List<HgNameWithHashInfo> mqAppliedPatches = repository.getMQAppliedPatches();
        HashSet<VcsRef> refs = new HashSet<VcsRef>(branches.size() + bookmarks.size());
        for (Map.Entry<String, LinkedHashSet<Hash>> entry : branches.entrySet()) {
            String branchName = entry.getKey();
            boolean opened = openedBranchNames.contains(branchName);
            for (Hash hash : entry.getValue()) {
                refs.add(this.myVcsObjectsFactory.createRef(hash, branchName, opened ? HgRefManager.BRANCH : HgRefManager.CLOSED_BRANCH, root));
            }
        }
        for (HgNameWithHashInfo bookmarkInfo : bookmarks) {
            refs.add(this.myVcsObjectsFactory.createRef(bookmarkInfo.getHash(), bookmarkInfo.getName(), HgRefManager.BOOKMARK, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(currentRevision), "HEAD", HgRefManager.HEAD, root));
        }
        if ((tipRevision = repository.getTipRevision()) != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(tipRevision), "tip", HgRefManager.TIP, root));
        }
        for (HgNameWithHashInfo tagInfo : tags) {
            refs.add(this.myVcsObjectsFactory.createRef(tagInfo.getHash(), tagInfo.getName(), HgRefManager.TAG, root));
        }
        for (HgNameWithHashInfo localTagInfo : localTags) {
            refs.add(this.myVcsObjectsFactory.createRef(localTagInfo.getHash(), localTagInfo.getName(), HgRefManager.LOCAL_TAG, root));
        }
        for (HgNameWithHashInfo mqPatchRef : mqAppliedPatches) {
            refs.add(this.myVcsObjectsFactory.createRef(mqPatchRef.getHash(), mqPatchRef.getName(), HgRefManager.MQ_APPLIED_TAG, root));
        }
        HashSet<VcsRef> hashSet = refs;
        if (hashSet == null) {
            HgLogProvider.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            HgLogProvider.$$$reportNull$$$0(17);
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            HgLogProvider.$$$reportNull$$$0(18);
        }
        return vcsLogRefManager;
    }

    @NotNull
    public Disposable subscribeToRootRefreshEvents(final @NotNull Collection<? extends VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            HgLogProvider.$$$reportNull$$$0(19);
        }
        if (refresher == null) {
            HgLogProvider.$$$reportNull$$$0(20);
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, @Nullable VirtualFile root) {
                if (root != null && roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            HgLogProvider.$$$reportNull$$$0(21);
        }
        return messageBusConnection;
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) {
        VcsLogStructureFilter structureFilter;
        VcsLogTextFilter textFilter;
        VcsLogDateFilter dateFilter;
        VcsLogUserFilter userFilter;
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(22);
        }
        if (filterCollection == null) {
            HgLogProvider.$$$reportNull$$$0(23);
        }
        ArrayList<String> filterParameters = new ArrayList<String>();
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filterCollection.get(VcsLogFilterCollection.BRANCH_FILTER);
        if (branchFilter != null) {
            HgRepository repository = (HgRepository)HgLogProvider.getHgRepoManager(this.myProject).getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository not found for root " + root);
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    HgLogProvider.$$$reportNull$$$0(24);
                }
                return list;
            }
            Set<String> branchNames = repository.getBranches().keySet();
            List<String> bookmarkNames = HgUtil.getNamesWithoutHashes(repository.getBookmarks());
            List<String> predefinedNames = Collections.singletonList("tip");
            boolean atLeastOneBranchExists = false;
            for (String branchName : ContainerUtil.concat((Iterable[])new Iterable[]{branchNames, bookmarkNames, predefinedNames})) {
                if (!branchFilter.matches(branchName)) continue;
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", branchName));
                atLeastOneBranchExists = true;
            }
            if (branchFilter.matches("HEAD")) {
                filterParameters.add(HgHistoryUtil.prepareParameter("branch", "."));
                filterParameters.add("-r");
                filterParameters.add("::.");
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    HgLogProvider.$$$reportNull$$$0(25);
                }
                return list;
            }
        }
        if ((userFilter = (VcsLogUserFilter)filterCollection.get(VcsLogFilterCollection.USER_FILTER)) != null) {
            filterParameters.add("-r");
            String authorFilter = StringUtil.join((Collection)ContainerUtil.map((Collection)ContainerUtil.map((Collection)userFilter.getUsers(root), VcsUserUtil::toExactString), (Function)UserNameRegex.EXTENDED_INSTANCE), (String)"|");
            filterParameters.add("user('re:" + authorFilter + "')");
        }
        if ((dateFilter = (VcsLogDateFilter)filterCollection.get(VcsLogFilterCollection.DATE_FILTER)) != null) {
            StringBuilder args = new StringBuilder();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            filterParameters.add("-d");
            if (dateFilter.getAfter() != null) {
                if (dateFilter.getBefore() != null) {
                    args.append(dateFormatter.format(dateFilter.getAfter())).append(" to ").append(dateFormatter.format(dateFilter.getBefore()));
                } else {
                    args.append('>').append(dateFormatter.format(dateFilter.getAfter()));
                }
            } else if (dateFilter.getBefore() != null) {
                args.append('<').append(dateFormatter.format(dateFilter.getBefore()));
            }
            filterParameters.add(args.toString());
        }
        if ((textFilter = (VcsLogTextFilter)filterCollection.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
            String text = textFilter.getText();
            if (textFilter.isRegex()) {
                filterParameters.add("-r");
                filterParameters.add("grep(r'" + text + "')");
            } else if (textFilter.matchesCase()) {
                filterParameters.add("-r");
                filterParameters.add("grep(r'" + StringUtil.escapeChars((String)text, (char[])UserNameRegex.EXTENDED_REGEX_CHARS) + "')");
            } else {
                filterParameters.add(HgHistoryUtil.prepareParameter("keyword", text));
            }
        }
        if ((structureFilter = (VcsLogStructureFilter)filterCollection.get(VcsLogFilterCollection.STRUCTURE_FILTER)) != null) {
            for (FilePath file : structureFilter.getFiles()) {
                filterParameters.add(file.getPath());
            }
        }
        List<TimedVcsCommit> list = HgHistoryUtil.readHashes(this.myProject, root, (Consumer<? super VcsUser>)Consumer.EMPTY_CONSUMER, maxCount, filterParameters);
        if (list == null) {
            HgLogProvider.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) {
        String userName;
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(27);
        }
        if ((userName = HgConfig.getInstance(this.myProject, root).getNamedConfig("ui", "username")) == null && (userName = System.getenv("HGUSER")) == null && (userName = System.getenv("USER")) == null && (userName = System.getenv("LOGNAME")) == null) {
            return null;
        }
        Couple<String> userArgs = HgUtil.parseUserNameAndEmail(userName);
        return this.myVcsObjectsFactory.createUser((String)userArgs.getFirst(), (String)userArgs.getSecond());
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(28);
        }
        if (commitHash == null) {
            HgLogProvider.$$$reportNull$$$0(29);
        }
        Collection<String> collection = HgHistoryUtil.getDescendingHeadsOfBranches(this.myProject, root, commitHash);
        if (collection == null) {
            HgLogProvider.$$$reportNull$$$0(30);
        }
        return collection;
    }

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile root) {
        HgRepository repository;
        if (root == null) {
            HgLogProvider.$$$reportNull$$$0(31);
        }
        if ((repository = (HgRepository)HgLogProvider.getHgRepoManager(this.myProject).getRepositoryForRoot(root)) == null) {
            return null;
        }
        return repository.getCurrentBranchName();
    }

    @NotNull
    private static HgRepositoryManager getHgRepoManager(@NotNull Project project) {
        if (project == null) {
            HgLogProvider.$$$reportNull$$$0(32);
        }
        HgRepositoryManager hgRepositoryManager = (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
        if (hgRepositoryManager == null) {
            HgLogProvider.$$$reportNull$$$0(33);
        }
        return hgRepositoryManager;
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.CASE_INSENSITIVE_REGEX) {
            return (T)Boolean.FALSE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 22: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgLogProvider";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgLogProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readFirstBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readAllHashes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readMetadata";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readAllRefs";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceManager";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribeToRootRefreshEvents";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsMatchingFilter";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getHgRepoManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readFirstBlock";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readAllHashes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readMetadata";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readAllRefs";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToRootRefreshEvents";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsMatchingFilter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentUser";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranch";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getHgRepoManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

