/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.Convertor;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserNode<T>
extends DefaultMutableTreeNode
implements UserDataHolderEx {
    @NonNls
    private static final String ROOT_NODE_VALUE = "root";
    public static final Object IGNORED_FILES_TAG = new Tag("changes.nodetitle.ignored.files");
    public static final Object LOCKED_FOLDERS_TAG = new Tag("changes.nodetitle.locked.folders");
    public static final Object LOGICALLY_LOCKED_TAG = new Tag("changes.nodetitle.logicallt.locked.folders");
    public static final Object UNVERSIONED_FILES_TAG = new Tag("changes.nodetitle.unversioned.files");
    public static final Object MODIFIED_WITHOUT_EDITING_TAG = new Tag("changes.nodetitle.modified.without.editing");
    public static final Object SWITCHED_FILES_TAG = new Tag("changes.nodetitle.switched.files");
    public static final Object SWITCHED_ROOTS_TAG = new Tag("changes.nodetitle.switched.roots");
    public static final Object LOCALLY_DELETED_NODE_TAG = new Tag("changes.nodetitle.locally.deleted.files");
    protected static final int CONFLICTS_SORT_WEIGHT = 0;
    protected static final int DEFAULT_CHANGE_LIST_SORT_WEIGHT = 1;
    protected static final int CHANGE_LIST_SORT_WEIGHT = 2;
    protected static final int REPOSITORY_SORT_WEIGHT = 3;
    protected static final int MODULE_SORT_WEIGHT = 4;
    protected static final int DIRECTORY_PATH_SORT_WEIGHT = 5;
    protected static final int FILE_PATH_SORT_WEIGHT = 6;
    protected static final int CHANGE_SORT_WEIGHT = 7;
    protected static final int VIRTUAL_FILE_SORT_WEIGHT = 8;
    protected static final int UNVERSIONED_SORT_WEIGHT = 9;
    protected static final int DEFAULT_SORT_WEIGHT = 10;
    protected static final int IGNORED_SORT_WEIGHT = 11;
    public static final Convertor<TreePath, String> TO_TEXT_CONVERTER = path -> ((ChangesBrowserNode)path.getLastPathComponent()).getTextPresentation();
    private SimpleTextAttributes myAttributes;
    private int myFileCount = -1;
    private int myDirectoryCount = -1;
    private boolean myHelper;
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();

    protected ChangesBrowserNode(T userObject) {
        super(userObject);
        this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    @NotNull
    public static ChangesBrowserNode createRoot() {
        ChangesBrowserNode root = ChangesBrowserNode.createObject(ROOT_NODE_VALUE);
        root.markAsHelperNode();
        ChangesBrowserNode changesBrowserNode = root;
        if (changesBrowserNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(0);
        }
        return changesBrowserNode;
    }

    @NotNull
    public static ChangesBrowserNode createChange(@Nullable Project project, @NotNull Change userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(1);
        }
        ChangesBrowserChangeNode changesBrowserChangeNode = new ChangesBrowserChangeNode(project, userObject, null);
        if (changesBrowserChangeNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(2);
        }
        return changesBrowserChangeNode;
    }

    @NotNull
    public static ChangesBrowserNode createFile(@Nullable Project project, @NotNull VirtualFile userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(3);
        }
        ChangesBrowserFileNode changesBrowserFileNode = new ChangesBrowserFileNode(project, userObject);
        if (changesBrowserFileNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(4);
        }
        return changesBrowserFileNode;
    }

    @NotNull
    public static ChangesBrowserNode createFilePath(@NotNull FilePath userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(5);
        }
        ChangesBrowserFilePathNode changesBrowserFilePathNode = new ChangesBrowserFilePathNode(userObject);
        if (changesBrowserFilePathNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(6);
        }
        return changesBrowserFilePathNode;
    }

    @NotNull
    public static ChangesBrowserNode createLogicallyLocked(@Nullable Project project, @NotNull VirtualFile file, @NotNull LogicalLock lock) {
        if (file == null) {
            ChangesBrowserNode.$$$reportNull$$$0(7);
        }
        if (lock == null) {
            ChangesBrowserNode.$$$reportNull$$$0(8);
        }
        ChangesBrowserLogicallyLockedFile changesBrowserLogicallyLockedFile = new ChangesBrowserLogicallyLockedFile(project, file, lock);
        if (changesBrowserLogicallyLockedFile == null) {
            ChangesBrowserNode.$$$reportNull$$$0(9);
        }
        return changesBrowserLogicallyLockedFile;
    }

    @NotNull
    public static ChangesBrowserNode createLockedFolders(@NotNull Project project) {
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(10);
        }
        ChangesBrowserLockedFoldersNode changesBrowserLockedFoldersNode = new ChangesBrowserLockedFoldersNode(project, LOCKED_FOLDERS_TAG);
        if (changesBrowserLockedFoldersNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(11);
        }
        return changesBrowserLockedFoldersNode;
    }

    @NotNull
    public static ChangesBrowserNode createLocallyDeleted(@NotNull LocallyDeletedChange change) {
        if (change == null) {
            ChangesBrowserNode.$$$reportNull$$$0(12);
        }
        ChangesBrowserLocallyDeletedNode changesBrowserLocallyDeletedNode = new ChangesBrowserLocallyDeletedNode(change);
        if (changesBrowserLocallyDeletedNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(13);
        }
        return changesBrowserLocallyDeletedNode;
    }

    @NotNull
    public static ChangesBrowserNode createObject(@NotNull Object userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(14);
        }
        ChangesBrowserNode<Object> changesBrowserNode = new ChangesBrowserNode<Object>(userObject);
        if (changesBrowserNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(15);
        }
        return changesBrowserNode;
    }

    @Deprecated
    @NotNull
    public static ChangesBrowserNode create(@NotNull Project project, @NotNull Object userObject) {
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(16);
        }
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(17);
        }
        if (userObject instanceof Change) {
            ChangesBrowserChangeNode changesBrowserChangeNode = new ChangesBrowserChangeNode(project, (Change)userObject, null);
            if (changesBrowserChangeNode == null) {
                ChangesBrowserNode.$$$reportNull$$$0(18);
            }
            return changesBrowserChangeNode;
        }
        if (userObject instanceof VirtualFile) {
            ChangesBrowserFileNode changesBrowserFileNode = new ChangesBrowserFileNode(project, (VirtualFile)userObject);
            if (changesBrowserFileNode == null) {
                ChangesBrowserNode.$$$reportNull$$$0(19);
            }
            return changesBrowserFileNode;
        }
        if (userObject instanceof FilePath) {
            ChangesBrowserFilePathNode changesBrowserFilePathNode = new ChangesBrowserFilePathNode((FilePath)userObject);
            if (changesBrowserFilePathNode == null) {
                ChangesBrowserNode.$$$reportNull$$$0(20);
            }
            return changesBrowserFilePathNode;
        }
        if (userObject == LOCKED_FOLDERS_TAG) {
            ChangesBrowserLockedFoldersNode changesBrowserLockedFoldersNode = new ChangesBrowserLockedFoldersNode(project, userObject);
            if (changesBrowserLockedFoldersNode == null) {
                ChangesBrowserNode.$$$reportNull$$$0(21);
            }
            return changesBrowserLockedFoldersNode;
        }
        if (userObject instanceof ChangesBrowserLogicallyLockedFile) {
            ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)userObject;
            if (changesBrowserNode == null) {
                ChangesBrowserNode.$$$reportNull$$$0(22);
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode<Object> changesBrowserNode = new ChangesBrowserNode<Object>(userObject);
        if (changesBrowserNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(23);
        }
        return changesBrowserNode;
    }

    @Override
    public ChangesBrowserNode<?> getParent() {
        return (ChangesBrowserNode)super.getParent();
    }

    @Nullable
    public <V> V getUserData(@NotNull Key<V> key) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(24);
        }
        return (V)this.myUserDataHolder.getUserData(key);
    }

    public <V> void putUserData(@NotNull Key<V> key, @Nullable V value) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(25);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <V> V putUserDataIfAbsent(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(26);
        }
        if (value == null) {
            ChangesBrowserNode.$$$reportNull$$$0(27);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            ChangesBrowserNode.$$$reportNull$$$0(28);
        }
        return (V)object;
    }

    public <V> boolean replace(@NotNull Key<V> key, @Nullable V oldValue, @Nullable V newValue) {
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(29);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.resetFileCounters();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.resetFileCounters();
    }

    protected boolean isFile() {
        return false;
    }

    protected boolean isDirectory() {
        return false;
    }

    public void markAsHelperNode() {
        this.myHelper = true;
    }

    public boolean isMeaningfulNode() {
        return !this.myHelper;
    }

    public int getFileCount() {
        if (this.myFileCount == -1) {
            this.myFileCount = (this.isFile() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getFileCount).sum();
        }
        return this.myFileCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getDirectoryCount).sum();
        }
        return this.myDirectoryCount;
    }

    private void resetFileCounters() {
        this.myFileCount = -1;
        this.myDirectoryCount = -1;
    }

    @NotNull
    public Stream<ChangesBrowserNode<?>> getNodesUnderStream() {
        StreamEx<ChangesBrowserNode<?>> streamEx = ChangesBrowserNode.toStream(this.preorderEnumeration());
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(30);
        }
        return streamEx;
    }

    @NotNull
    public List<Change> getAllChangesUnder() {
        List<Change> list = this.getAllObjectsUnder(Change.class);
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public <U> List<U> getAllObjectsUnder(@NotNull Class<U> clazz) {
        if (clazz == null) {
            ChangesBrowserNode.$$$reportNull$$$0(32);
        }
        List list = this.getObjectsUnderStream(clazz).collect(Collectors.toList());
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public <U> Stream<U> getObjectsUnderStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            ChangesBrowserNode.$$$reportNull$$$0(34);
        }
        StreamEx streamEx = ChangesBrowserNode.toStream(this.preorderEnumeration()).map(ChangesBrowserNode::getUserObject).select(clazz);
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(35);
        }
        return streamEx;
    }

    @NotNull
    public List<VirtualFile> getAllFilesUnder() {
        List<VirtualFile> list = this.getFilesUnderStream().collect(Collectors.toList());
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    public Stream<VirtualFile> getFilesUnderStream() {
        AbstractStreamEx abstractStreamEx = ChangesBrowserNode.toStream(this.preorderEnumeration()).map(ChangesBrowserNode::getUserObject).select(VirtualFile.class).filter(VirtualFile::isValid);
        if (abstractStreamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(37);
        }
        return abstractStreamEx;
    }

    @NotNull
    public List<FilePath> getAllFilePathsUnder() {
        List<FilePath> list = this.getFilePathsUnderStream().collect(Collectors.toList());
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public Stream<FilePath> getFilePathsUnderStream() {
        StreamEx streamEx = ((StreamEx)ChangesBrowserNode.toStream(this.preorderEnumeration()).filter(DefaultMutableTreeNode::isLeaf)).map(ChangesBrowserNode::getUserObject).select(FilePath.class);
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(39);
        }
        return streamEx;
    }

    @NotNull
    private static StreamEx<ChangesBrowserNode<?>> toStream(@NotNull Enumeration enumeration) {
        if (enumeration == null) {
            ChangesBrowserNode.$$$reportNull$$$0(40);
        }
        StreamEx streamEx = StreamEx.of((Enumeration)enumeration);
        if (streamEx == null) {
            ChangesBrowserNode.$$$reportNull$$$0(41);
        }
        return streamEx;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(42);
        }
        renderer.append(this.userObject.toString(), this.myAttributes);
        this.appendCount(renderer);
    }

    @NotNull
    protected String getCountText() {
        int count = this.getFileCount();
        int dirCount = this.getDirectoryCount();
        String result2 = "";
        if (dirCount != 0 || count != 0) {
            result2 = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count}) : (count == 0 ? VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount}) : VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count})));
        }
        String string = result2;
        if (string == null) {
            ChangesBrowserNode.$$$reportNull$$$0(43);
        }
        return string;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(44);
        }
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    public String getTextPresentation() {
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 10;
    }

    public int compareUserObjects(T o2) {
        return 0;
    }

    protected static int compareFileNames(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(45);
        }
        if (name2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(46);
        }
        return FileNameComparator.INSTANCE.compare(name1, name2);
    }

    protected static int compareFilePaths(@NotNull FilePath path1, @NotNull FilePath path2) {
        if (path1 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(47);
        }
        if (path2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(48);
        }
        return HierarchicalFilePathComparator.NATURAL.compare(path1, path2);
    }

    public void setAttributes(@NotNull SimpleTextAttributes attributes2) {
        if (attributes2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(49);
        }
        this.myAttributes = attributes2;
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable FilePath parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(50);
        }
        if (parentPath != null) {
            ChangesBrowserNode.appendParentPath(renderer, parentPath.getPresentableUrl());
        }
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable VirtualFile parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(51);
        }
        if (parentPath != null) {
            ChangesBrowserNode.appendParentPath(renderer, parentPath.getPresentableUrl());
        }
    }

    private static void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @NotNull String parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(52);
        }
        if (parentPath == null) {
            ChangesBrowserNode.$$$reportNull$$$0(53);
        }
        renderer.append(FontUtil.spaceAndThinSpace() + FileUtil.getLocationRelativeToUserHome((String)parentPath), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    protected void appendUpdatingState(@NotNull ChangesBrowserNodeRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(54);
        }
        renderer.append((this.getCountText().isEmpty() ? FontUtil.spaceAndThinSpace() : ", ") + VcsBundle.message((String)"changes.nodetitle.updating", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Deprecated
    public final int getCount() {
        return this.getFileCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 42: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRoot";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogicallyLocked";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockedFolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocallyDeleted";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createObject";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesUnderStream";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChangesUnder";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllObjectsUnder";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsUnderStream";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesUnder";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesUnderStream";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilePathsUnder";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathsUnderStream";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toStream";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLogicallyLocked";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLockedFolders";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLocallyDeleted";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createObject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAllObjectsUnder";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsUnderStream";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toStream";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "appendCount";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "compareFileNames";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "compareFilePaths";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "appendParentPath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "appendUpdatingState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Tag {
        @NotNull
        private final String myKey;

        Tag(@NotNull String key) {
            if (key == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        public String toString() {
            return VcsBundle.message((String)this.myKey, (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag", "<init>"));
        }
    }
}

