/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.JdomSerializer;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.xml.KotlinAwareBeanBinding;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a2\u0006\u0002\u0010\tJ)\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J3\u0010\u0014\u001a\u0004\u0018\u00010\u000b\"\b\b\u0000\u0010\u0004*\u00020\u00112\u0006\u0010\u0010\u001a\u0002H\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/JdomSerializerImpl;", "Lcom/intellij/configurationStore/JdomSerializer;", "()V", "deserialize", "T", "url", "Ljava/net/URL;", "aClass", "Ljava/lang/Class;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "element", "Lorg/jdom/Element;", "clazz", "(Lorg/jdom/Element;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeInto", "", "obj", "", "getDefaultSerializationFilter", "Lcom/intellij/util/xmlb/SkipDefaultsSerializationFilter;", "serialize", "filter", "Lcom/intellij/util/xmlb/SerializationFilter;", "createElementIfEmpty", "", "(Ljava/lang/Object;Lcom/intellij/util/xmlb/SerializationFilter;Z)Lorg/jdom/Element;", "serializeObjectInto", "target", "intellij.platform.objectSerializer"})
public final class JdomSerializerImpl
implements JdomSerializer {
    @NotNull
    public SkipDefaultsSerializationFilter getDefaultSerializationFilter() {
        return XmlSerializerKt.access$doGetDefaultSerializationFilter();
    }

    @Nullable
    public <T> Element serialize(@NotNull T obj2, @Nullable SerializationFilter filter, boolean createElementIfEmpty) {
        Intrinsics.checkParameterIsNotNull(obj2, (String)"obj");
        try {
            Element element;
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
            if (binding instanceof BeanBinding) {
                element = ((BeanBinding)binding).serialize(obj2, createElementIfEmpty, filter);
            } else {
                Object object = binding.serialize(obj2, null, filter);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jdom.Element");
                }
                element = (Element)object;
            }
            return element;
        }
        catch (SerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Can't serialize instance of " + obj2.getClass(), (Throwable)e);
        }
    }

    public void serializeObjectInto(@NotNull Object obj2, @NotNull Element target, @Nullable SerializationFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (obj2 instanceof Element) {
            Iterator attributeIterator;
            Iterator iterator;
            Iterator iterator2 = iterator = ((Element)obj2).getChildren().iterator();
            boolean bl = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Element child = (Element)iterator3.next();
                iterator.remove();
                target.addContent(child);
            }
            Iterator iterator4 = attributeIterator = ((Element)obj2).getAttributes().iterator();
            boolean bl2 = false;
            iterator2 = iterator4;
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)iterator2.next();
                attributeIterator.remove();
                target.setAttribute(attribute);
            }
            return;
        }
        Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
        if (binding == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.serialization.xml.KotlinAwareBeanBinding");
        }
        KotlinAwareBeanBinding beanBinding = (KotlinAwareBeanBinding)binding;
        SerializationFilter serializationFilter = filter;
        if (serializationFilter == null) {
            serializationFilter = (SerializationFilter)this.getDefaultSerializationFilter();
        }
        beanBinding.serializeInto(obj2, target, serializationFilter);
    }

    public <T> T deserialize(@NotNull Element element, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (Intrinsics.areEqual(clazz, Element.class)) {
            return (T)element;
        }
        try {
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(clazz);
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.NotNullDeserializeBinding");
            }
            return (T)((NotNullDeserializeBinding)binding).deserialize(null, element);
        }
        catch (SerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException("Cannot deserialize class " + clazz.getName(), (Throwable)e);
        }
    }

    public void deserializeInto(@NotNull Object obj2, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        try {
            Binding binding = XmlSerializerKt.access$getSerializer$p().getRootBinding(obj2.getClass());
            if (binding == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.xmlb.BeanBinding");
            }
            ((BeanBinding)binding).deserializeInto(obj2, element);
        }
        catch (SerializationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
    }

    public <T> T deserialize(@NotNull URL url, @NotNull Class<T> aClass) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        try {
            Document document = JDOMUtil.loadDocument((InputStream)URLUtil.openStream((URL)url));
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"JDOMUtil.loadDocument(URLUtil.openStream(url))");
            Document document2 = document;
            Document document3 = JDOMXIncluder.resolve((Document)document2, (String)url.toExternalForm());
            Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"JDOMXIncluder.resolve(do\u2026nt, url.toExternalForm())");
            document2 = document3;
            Element element = document2.getRootElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.rootElement");
            return this.deserialize(element, aClass);
        }
        catch (IOException e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
        catch (JDOMException e) {
            throw (Throwable)new XmlSerializationException((Throwable)e);
        }
    }
}

