/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.Console;
import processing.app.Language;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Settings;
import processing.app.SingleInstance;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchReference;
import processing.app.UpdateCheck;
import processing.app.Util;
import processing.app.contrib.ContribProgressMonitor;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionListing;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.IgnorableException;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.ToolContribution;
import processing.app.tools.Tool;
import processing.app.ui.Editor;
import processing.app.ui.EditorConsole;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.app.ui.PreferencesFrame;
import processing.app.ui.Recent;
import processing.app.ui.Welcome;
import processing.core.PApplet;
import processing.data.StringList;

public class Base {
    private static final int REVISION = 269;
    private static String VERSION_NAME = "0269";
    public static boolean DEBUG;
    private static boolean commandLine;
    PreferencesFrame preferencesFrame;
    static File untitledFolder;
    protected List<Editor> editors = Collections.synchronizedList(new ArrayList());
    protected Editor activeEditor;
    public static JMenu defaultFileMenu;
    private Mode nextMode;
    private Mode[] coreModes;
    protected List<ModeContribution> modeContribs;
    protected List<ExamplesContribution> exampleContribs;
    private JMenu sketchbookMenu;
    private JFileChooser openChooser;
    protected static File sketchbookFolder;
    private int updatesAvailable = 0;
    List<Tool> internalTools;
    List<ToolContribution> coreTools;
    List<ToolContribution> contribTools;
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Base.createAndShowGUI(args);
                }
                catch (Throwable t) {
                    if (Platform.isWindows()) {
                        String mess = t.getMessage();
                        String missing = null;
                        if (mess.contains("Could not initialize class com.sun.jna.Native")) {
                            missing = "jnidispatch.dll";
                        } else if (mess.contains("NoClassDefFoundError: processing/core/PApplet")) {
                            missing = "core.jar";
                        }
                        if (missing != null) {
                            Messages.showError("Necessary files are missing", "A file required by Processing (" + missing + ") is missing.\n\n" + "Make sure that you're not trying to run Processing from inside\n" + "the .zip file you downloaded, and check that Windows Defender\n" + "hasn't removed files from the Processing folder.\n\n" + "(It sometimes flags parts of Processing as a trojan or virus.\n" + "It is neither, but Microsoft has ignored our pleas for help.)", t);
                        }
                    }
                    Messages.showTrace("Unknown Problem", "A serious error happened during startup. Please report:\nhttp://github.com/processing/processing/issues/new", t, true);
                }
            }
        });
    }

    private static void createAndShowGUI(String[] args) {
        try {
            String version;
            File versionFile = Platform.getContentFile("lib/version.txt");
            if (versionFile.exists() && !(version = PApplet.loadStrings((File)versionFile)[0]).equals(VERSION_NAME)) {
                VERSION_NAME = version;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Platform.init();
        Console.startup();
        File debugFile = Base.getSettingsFile("debug.txt");
        if (debugFile.exists()) {
            DEBUG = true;
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        Language.init();
        Preferences.init();
        if (!SingleInstance.alreadyRunning(args)) {
            String oldPath;
            try {
                Platform.setLookAndFeel();
            }
            catch (Exception e) {
                Messages.loge("Could not set the Look & Feel", e);
            }
            boolean sketchbookPrompt = false;
            if (Preferences.getBoolean("welcome.show") && !Preferences.getBoolean("welcome.seen") && (oldPath = Preferences.getOldSketchbookPath()) != null) {
                String newPath = Preferences.getSketchbookPath();
                if (newPath == null) {
                    sketchbookPrompt = true;
                } else if (oldPath.equals(newPath)) {
                    sketchbookPrompt = true;
                }
            }
            Base.locateSketchbookFolder();
            try {
                untitledFolder = Util.createTempFolder("untitled", "sketches", null);
                untitledFolder.deleteOnExit();
            }
            catch (IOException e) {
                Messages.showError("Trouble without a name", "Could not create a place to store untitled sketches.\nThat's gonna prevent us from continuing.", e);
            }
            Messages.log("About to create Base...");
            try {
                Base base = new Base(args);
                Messages.log("Base() constructor succeeded");
                SingleInstance.startServer(base);
                if (Preferences.getBoolean("welcome.show")) {
                    try {
                        new Welcome(base, sketchbookPrompt);
                    }
                    catch (IOException e) {
                        Messages.showTrace("Unwelcoming", "Please report this error to\nhttps://github.com/processing/processing/issues", e, false);
                    }
                }
                Base.checkDriverBug();
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                Messages.showTrace("We're off on the wrong foot", "An error occurred during startup.", t, true);
            }
            Messages.log("Done creating Base...");
        }
    }

    private static void checkDriverBug() {
        if (System.getProperty("os.name").contains("Windows 10")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Process p = Runtime.getRuntime().exec("powershell Get-WmiObject Win32_PnPSignedDriver| select devicename, driverversion | where {$_.devicename -like \\\"*nvidia*\\\"}");
                        BufferedReader reader = PApplet.createReader((InputStream)p.getInputStream());
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (line.contains("3.7849")) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Messages.showWarning("NVIDIA screwed up", "Due to an NVIDIA bug, you need to update your graphics drivers,\notherwise you won't be able to run any sketches. Update here:\nhttp://nvidia.custhelp.com/app/answers/detail/a_id/4378\nor read background about the issue at this link:\nhttps://github.com/processing/processing/issues/4853");
                                    }
                                });
                                continue;
                            }
                            if (!line.contains("3.8165")) continue;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showWarning("NVIDIA screwed up again", "Due to an NVIDIA bug, you need to update your graphics drivers,\notherwise you won't be able to run any sketches. Update here:\nhttp://nvidia.custhelp.com/app/answers/detail/a_id/4453/\nor read background about the issue at this link:\nhttps://github.com/processing/processing/issues/4997");
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Messages.loge("Problem checking NVIDIA driver", e);
                    }
                }
            }).start();
        }
    }

    public static int getRevision() {
        return 269;
    }

    public static String getVersionName() {
        return VERSION_NAME;
    }

    public static void setCommandLine() {
        commandLine = true;
    }

    public static boolean isCommandLine() {
        return commandLine;
    }

    public Base(String[] args) throws Exception {
        ContributionManager.init(this);
        this.buildCoreModes();
        this.rebuildContribModes();
        this.rebuildContribExamples();
        Recent.init(this);
        String lastModeIdentifier = Preferences.get("mode.last");
        if (lastModeIdentifier == null) {
            this.nextMode = this.getDefaultMode();
            Messages.log("Nothing set for last.sketch.mode, using default.");
        } else {
            for (Mode m : this.getModeList()) {
                if (!m.getIdentifier().equals(lastModeIdentifier)) continue;
                Messages.logf("Setting next mode to %s.", lastModeIdentifier);
                this.nextMode = m;
            }
            if (this.nextMode == null) {
                this.nextMode = this.getDefaultMode();
                Messages.logf("Could not find mode %s, using default.", lastModeIdentifier);
            }
        }
        this.nextMode.rebuildLibraryList();
        Platform.initBase(this);
        boolean opened = false;
        int i = 0;
        while (i < args.length) {
            Messages.logf("Parsing command line... args[%d] = '%s'", i, args[i]);
            String path = args[i];
            if (Platform.isWindows()) {
                try {
                    File file = new File(args[i]);
                    path = file.getCanonicalPath();
                    Messages.logf("Changing %s to canonical %s", i, args[i], path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.handleOpen(path) != null) {
                opened = true;
            }
            ++i;
        }
        if (!opened) {
            Messages.log("Calling handleNew() to open a new window");
            this.handleNew();
        } else {
            Messages.log("No handleNew(), something passed on the command line");
        }
        new UpdateCheck(this);
        ContributionListing cl = ContributionListing.getInstance();
        cl.downloadAvailableList(this, new ContribProgressMonitor(){});
    }

    void buildCoreModes() {
        Mode javaMode = ModeContribution.load(this, Platform.getContentFile("modes/java"), this.getDefaultModeIdentifier()).getMode();
        this.coreModes = new Mode[]{javaMode};
    }

    void rebuildContribModes() {
        String useMode;
        if (this.modeContribs == null) {
            this.modeContribs = new ArrayList<ModeContribution>();
        }
        File modesFolder = Base.getSketchbookModesFolder();
        List<ModeContribution> contribModes = this.getModeContribs();
        HashMap<File, ModeContribution> known = new HashMap<File, ModeContribution>();
        for (ModeContribution contrib : contribModes) {
            known.put(contrib.getFolder(), contrib);
        }
        File[] potential = ContributionType.MODE.listCandidates(modesFolder);
        if (potential != null) {
            File[] fileArray = potential;
            int n = potential.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                if (!known.containsKey(folder)) {
                    try {
                        contribModes.add(new ModeContribution(this, folder, null));
                    }
                    catch (NoSuchMethodError nsme) {
                        System.err.println(String.valueOf(folder.getName()) + " is not compatible with this version of Processing");
                        if (DEBUG) {
                            nsme.printStackTrace();
                        }
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        System.err.println(String.valueOf(folder.getName()) + " is not compatible with this version of Processing");
                        if (DEBUG) {
                            ncdfe.printStackTrace();
                        }
                    }
                    catch (InvocationTargetException ite) {
                        System.err.println(String.valueOf(folder.getName()) + " could not be loaded and may not compatible with this version of Processing");
                        if (DEBUG) {
                            ite.printStackTrace();
                        }
                    }
                    catch (IgnorableException ig) {
                        Messages.log(ig.getMessage());
                        if (DEBUG) {
                            ig.printStackTrace();
                        }
                    }
                    catch (Throwable e) {
                        System.err.println("Could not load Mode from " + folder);
                        e.printStackTrace();
                    }
                } else {
                    known.remove(folder);
                }
                ++n2;
            }
        }
        if ((useMode = System.getProperty("usemode")) != null) {
            String[] modeInfo = useMode.split(":", 2);
            String modeClass = modeInfo[0];
            String modeResourcePath = modeInfo[1];
            System.out.println("Attempting to load " + modeClass + " with resources at " + modeResourcePath);
            ModeContribution mc = ModeContribution.load(this, new File(modeResourcePath), modeClass);
            contribModes.add(mc);
            File key = Base.getFileForContrib(mc, known);
            if (key != null) {
                known.remove(key);
            }
        }
        if (known.size() != 0) {
            for (ModeContribution mc : known.values()) {
                System.out.println("Extraneous Mode entry: " + mc.getName());
            }
        }
    }

    private static File getFileForContrib(ModeContribution contrib, Map<File, ModeContribution> known) {
        for (Map.Entry<File, ModeContribution> entry : known.entrySet()) {
            if (entry.getValue() != contrib) continue;
            return entry.getKey();
        }
        return null;
    }

    void rebuildContribExamples() {
        if (this.exampleContribs == null) {
            this.exampleContribs = new ArrayList<ExamplesContribution>();
        }
        ExamplesContribution.loadMissing(this);
    }

    public void checkFirstEditor(Editor editor) {
        if (this.activeEditor == null) {
            this.activeEditor = editor;
        }
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public List<Editor> getEditors() {
        return this.editors;
    }

    public void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsole.setEditor(this.activeEditor);
        this.nextMode = whichEditor.getMode();
        Preferences.set("mode.last", this.nextMode.getIdentifier());
    }

    public void refreshContribs(ContributionType ct) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (ct != ContributionType.LIBRARY) break block4;
                        for (Mode m : this.getModeList()) {
                            m.rebuildImportMenu();
                        }
                        break block5;
                    }
                    if (ct != ContributionType.MODE) break block6;
                    this.rebuildContribModes();
                    for (Editor editor : this.editors) {
                        editor.rebuildModePopup();
                    }
                    break block5;
                }
                if (ct != ContributionType.TOOL) break block7;
                this.rebuildToolList();
                for (Editor editor : this.editors) {
                    this.populateToolsMenu(editor.getToolMenu());
                }
                break block5;
            }
            if (ct != ContributionType.EXAMPLES) break block5;
            this.rebuildContribExamples();
            for (Mode m : this.getModeList()) {
                m.rebuildExamplesFrame();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdatesAvailable(int n) {
        this.updatesAvailable = n;
        List<Editor> list = this.editors;
        synchronized (list) {
            for (Editor e : this.editors) {
                e.setUpdatesAvailable(n);
            }
        }
    }

    public List<ToolContribution> getCoreTools() {
        return this.coreTools;
    }

    public List<ToolContribution> getToolContribs() {
        return this.contribTools;
    }

    public void removeToolContrib(ToolContribution tc) {
        this.contribTools.remove(tc);
    }

    public void rebuildToolList() {
        if (this.internalTools == null) {
            this.internalTools = new ArrayList<Tool>();
            this.initInternalTool("processing.app.tools.CreateFont");
            this.initInternalTool("processing.app.tools.ColorSelector");
            this.initInternalTool("processing.app.tools.Archiver");
            if (Platform.isMacOS()) {
                this.initInternalTool("processing.app.tools.InstallCommander");
            }
        }
        if (this.coreTools == null) {
            this.coreTools = ToolContribution.loadAll(Base.getToolsFolder());
            for (Tool tool : this.coreTools) {
                tool.init(this);
            }
        }
        this.contribTools = ToolContribution.loadAll(Base.getSketchbookToolsFolder());
        for (Tool tool : this.contribTools) {
            try {
                tool.init(this);
            }
            catch (VerifyError verifyError) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not " + "compatible with this version of Processing");
            }
            catch (NoSuchMethodError nsme) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not " + "compatible with this version of Processing");
                System.err.println("The " + nsme.getMessage() + " method no longer exists.");
                Messages.loge("Incompatible Tool found during tool.init()", nsme);
            }
            catch (NoClassDefFoundError ncdfe) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not " + "compatible with this version of Processing");
                System.err.println("The " + ncdfe.getMessage() + " class is no longer available.");
                Messages.loge("Incompatible Tool found during tool.init()", ncdfe);
            }
            catch (AbstractMethodError abstractMethodError) {
                System.err.println("\"" + tool.getMenuTitle() + "\" is not " + "compatible with this version of Processing");
            }
            catch (Error err) {
                System.err.println("An error occurred inside \"" + tool.getMenuTitle() + "\"");
                err.printStackTrace();
            }
            catch (Exception ex) {
                System.err.println("An exception occurred inside \"" + tool.getMenuTitle() + "\"");
                ex.printStackTrace();
            }
        }
    }

    protected void initInternalTool(String className) {
        try {
            Class<?> toolClass = Class.forName(className);
            Tool tool = (Tool)toolClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            tool.init(this);
            this.internalTools.add(tool);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearToolMenus() {
        for (Editor ed : this.editors) {
            ed.clearToolMenu();
        }
    }

    public void populateToolsMenu(JMenu toolsMenu) {
        if (this.internalTools == null) {
            this.rebuildToolList();
        }
        toolsMenu.removeAll();
        for (Tool tool : this.internalTools) {
            toolsMenu.add(this.createToolItem(tool));
        }
        toolsMenu.addSeparator();
        if (this.coreTools.size() > 0) {
            for (Tool tool : this.coreTools) {
                toolsMenu.add(this.createToolItem(tool));
            }
            toolsMenu.addSeparator();
        }
        if (this.contribTools.size() > 0) {
            for (Tool tool : this.contribTools) {
                toolsMenu.add(this.createToolItem(tool));
            }
            toolsMenu.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem(Language.text("menu.tools.add_tool"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributionManager.openTools();
            }
        });
        toolsMenu.add(jMenuItem);
    }

    JMenuItem createToolItem(final Tool tool) {
        String title = tool.getMenuTitle();
        final JMenuItem item = new JMenuItem(title);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    tool.run();
                }
                catch (NoSuchMethodError nsme) {
                    Base.this.activeEditor.statusError("\"" + tool.getMenuTitle() + "\" is not" + "compatible with this version of Processing");
                    Messages.loge("Incompatible tool found during tool.run()", nsme);
                    item.setEnabled(false);
                }
                catch (Exception ex) {
                    Base.this.activeEditor.statusError("An error occurred inside \"" + tool.getMenuTitle() + "\"");
                    ex.printStackTrace();
                    item.setEnabled(false);
                }
            }
        });
        return item;
    }

    public List<ModeContribution> getModeContribs() {
        return this.modeContribs;
    }

    public List<Mode> getModeList() {
        ArrayList<Mode> allModes = new ArrayList<Mode>();
        allModes.addAll(Arrays.asList(this.coreModes));
        if (this.modeContribs != null) {
            for (ModeContribution contrib : this.modeContribs) {
                allModes.add(contrib.getMode());
            }
        }
        return allModes;
    }

    public List<ExamplesContribution> getExampleContribs() {
        return this.exampleContribs;
    }

    private List<Contribution> getInstalledContribs() {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>();
        List<ModeContribution> modeContribs = this.getModeContribs();
        contributions.addAll(modeContribs);
        for (ModeContribution modeContrib : modeContribs) {
            Mode mode = modeContrib.getMode();
            contributions.addAll(new ArrayList<Library>(mode.contribLibraries));
        }
        contributions.addAll(ToolContribution.loadAll(Base.getSketchbookToolsFolder()));
        contributions.addAll(this.getExampleContribs());
        return contributions;
    }

    public byte[] getInstalledContribsInfo() {
        List<Contribution> contribs = this.getInstalledContribs();
        StringList entries = new StringList();
        for (Contribution c : contribs) {
            String entry = String.valueOf(c.getTypeName()) + "=" + PApplet.urlEncode((String)String.format("name=%s\nurl=%s\nrevision=%d\nversion=%s", c.getName(), c.getUrl(), c.getVersion(), c.getBenignVersion()));
            entries.append(entry);
        }
        String joined = "id=" + UpdateCheck.getUpdateID() + "&" + entries.join("&");
        return joined.getBytes();
    }

    private void saveModeSettings(File sketchProps, Mode mode) {
        try {
            Settings settings = new Settings(sketchProps);
            settings.set("mode", mode.getTitle());
            settings.set("mode.id", mode.getIdentifier());
            settings.save();
        }
        catch (IOException e) {
            System.err.println("While creating " + sketchProps + ": " + e.getMessage());
        }
    }

    String getDefaultModeIdentifier() {
        return "processing.mode.java.JavaMode";
    }

    public Mode getDefaultMode() {
        return this.coreModes[0];
    }

    public Mode getNextMode() {
        return this.nextMode;
    }

    public boolean changeMode(Mode mode) {
        Mode oldMode = this.activeEditor.getMode();
        if (oldMode != mode) {
            Sketch sketch = this.activeEditor.getSketch();
            this.nextMode = mode;
            if (sketch.isUntitled()) {
                this.handleClose(this.activeEditor, true);
                this.handleNew();
            } else {
                boolean newModeCanHandleCurrentSource = true;
                SketchCode[] sketchCodeArray = sketch.getCode();
                int n = sketchCodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SketchCode code = sketchCodeArray[n2];
                    if (!mode.validExtension(code.getExtension())) {
                        newModeCanHandleCurrentSource = false;
                        break;
                    }
                    ++n2;
                }
                if (!newModeCanHandleCurrentSource) {
                    return false;
                }
                File props = new File(sketch.getCodeFolder(), "sketch.properties");
                this.saveModeSettings(props, this.nextMode);
                this.handleClose(this.activeEditor, true);
                Editor editor = this.handleOpen(sketch.getMainFilePath());
                if (editor == null) {
                    this.saveModeSettings(props, oldMode);
                    this.handleOpen(sketch.getMainFilePath());
                    return false;
                }
            }
        }
        return true;
    }

    private static ModeInfo modeInfoFor(File sketch) {
        String id;
        String title;
        block4: {
            File sketchFolder = sketch.getParentFile();
            File sketchProps = new File(sketchFolder, "sketch.properties");
            if (!sketchProps.exists()) {
                return null;
            }
            try {
                Settings settings = new Settings(sketchProps);
                title = settings.get("mode");
                id = settings.get("mode.id");
                if (title != null && id != null) break block4;
                return null;
            }
            catch (IOException e) {
                System.err.println("While trying to read " + sketchProps + ": " + e.getMessage());
                return null;
            }
        }
        return new ModeInfo(id, title);
    }

    private Mode promptForMode(File sketch, ModeInfo preferredMode) {
        String extension = sketch.getName().substring(sketch.getName().lastIndexOf(46) + 1);
        ArrayList<Mode> possibleModes = new ArrayList<Mode>();
        for (Mode mode : this.getModeList()) {
            if (!mode.canEdit(sketch)) continue;
            possibleModes.add(mode);
        }
        if (possibleModes.size() == 1 && ((Mode)possibleModes.get(0)).getIdentifier().equals(this.getDefaultModeIdentifier())) {
            return (Mode)possibleModes.get(0);
        }
        if (possibleModes.size() == 0) {
            if (preferredMode == null) {
                String msg = "I don't know how to open a sketch with the \"" + extension + "\"\n" + "file extension. You'll have to install a different\n" + "Mode for that.";
                Messages.showWarning("Modeless Dialog", msg);
            } else {
                Messages.showWarning("Modeless Dialog", "Install " + preferredMode.title + " Mode " + "to open this sketch.");
            }
            return null;
        }
        Object[] modes = possibleModes.toArray(new Mode[possibleModes.size()]);
        String message = preferredMode == null ? String.valueOf(this.nextMode.getTitle()) + " Mode can't open ." + extension + " files, " + "but you have one or more modes\ninstalled that can. " + "Would you like to try one?" : "That's a " + preferredMode.title + " Mode sketch, " + "but you don't have " + preferredMode.title + " installed.\n" + "Would you like to try a different mode for opening a " + "." + extension + " sketch?";
        return (Mode)JOptionPane.showInputDialog(null, message, "Choose Wisely", 3, null, modes, modes[0]);
    }

    private Mode selectMode(File sketch) {
        Mode specifiedMode;
        ModeInfo modeInfo = Base.modeInfoFor(sketch);
        Mode mode = specifiedMode = modeInfo == null ? null : this.findMode(modeInfo.id);
        if (specifiedMode != null) {
            return specifiedMode;
        }
        return this.promptForMode(sketch, modeInfo);
    }

    protected Mode findMode(String id) {
        for (Mode mode : this.getModeList()) {
            if (!mode.getIdentifier().equals(id)) continue;
            return mode;
        }
        return null;
    }

    public void handleNew() {
        try {
            File newbieDir = null;
            String newbieName = null;
            File newbieParentDir = untitledFolder;
            String prefix = Preferences.get("editor.untitled.prefix");
            int index = 0;
            String format = Preferences.get("editor.untitled.suffix");
            String suffix = null;
            if (format == null) {
                Calendar cal = Calendar.getInstance();
                int day = cal.get(5);
                int month = cal.get(2);
                suffix = String.valueOf(this.months[month]) + PApplet.nf((int)day, (int)2);
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat(format);
                suffix = formatter.format(new Date());
            }
            do {
                if (index == 26) {
                    if (!this.breakTime) {
                        Messages.showWarning("Time for a Break", "You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?", null);
                        this.breakTime = true;
                    } else {
                        Messages.showWarning("Sunshine", "No really, time for some fresh air for you.", null);
                    }
                    return;
                }
                newbieName = String.valueOf(prefix) + suffix + (char)(97 + index);
                newbieName = Sketch.sanitizeName(newbieName);
                newbieDir = new File(newbieParentDir, newbieName);
                ++index;
            } while (newbieDir.exists() || new File(sketchbookFolder, newbieName).exists());
            newbieDir.mkdirs();
            File newbieFile = this.nextMode.addTemplateFiles(newbieDir, newbieName);
            if (!this.nextMode.equals(this.getDefaultMode())) {
                this.saveModeSettings(new File(newbieDir, "sketch.properties"), this.nextMode);
            }
            String path = newbieFile.getAbsolutePath();
            this.handleOpen(path, true);
        }
        catch (IOException e) {
            Messages.showWarning("That's new to me", "A strange and unexplainable error occurred\nwhile trying to create a new sketch.", e);
        }
    }

    public void handleOpenPrompt() {
        final StringList extensions = new StringList();
        for (Mode mode : this.getModeList()) {
            extensions.append(mode.getDefaultExtension());
        }
        String prompt = Language.text("open");
        if (Preferences.getBoolean("chooser.files.native")) {
            FileDialog openDialog = new FileDialog((Frame)this.activeEditor, prompt, 0);
            openDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (String ext : extensions) {
                        if (!name.toLowerCase().endsWith("." + ext)) continue;
                        return true;
                    }
                    return false;
                }
            });
            openDialog.setVisible(true);
            String directory = openDialog.getDirectory();
            String filename = openDialog.getFile();
            if (filename != null) {
                File inputFile = new File(directory, filename);
                this.handleOpen(inputFile.getAbsolutePath());
            }
        } else {
            if (this.openChooser == null) {
                this.openChooser = new JFileChooser();
            }
            this.openChooser.setDialogTitle(prompt);
            this.openChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    for (String ext : extensions) {
                        if (!file.getName().toLowerCase().endsWith("." + ext)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Processing Sketch";
                }
            });
            if (this.openChooser.showOpenDialog(this.activeEditor) == 0) {
                this.handleOpen(this.openChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public Editor handleOpen(String path) {
        return this.handleOpen(path, false);
    }

    public Editor handleOpen(String path, boolean untitled) {
        return this.handleOpen(path, untitled, new EditorState(this.editors));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Editor handleOpen(String path, boolean untitled, EditorState state) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            for (Editor editor : this.editors) {
                SketchCode[] sketchCodeArray = editor.getSketch().getCode();
                int n = sketchCodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SketchCode tab = sketchCodeArray[n2];
                    if (tab.getFile().equals(file)) {
                        editor.toFront();
                        Recent.append(editor);
                        return editor;
                    }
                    ++n2;
                }
            }
            if (!Sketch.isSanitaryName(file.getName())) {
                Messages.showWarning("You're tricky, but not tricky enough", String.valueOf(file.getName()) + " is not a valid name for a sketch.\n" + "Better to stick to ASCII, no spaces, and make sure\n" + "it doesn't start with a number.", null);
                return null;
            }
            if (!this.nextMode.canEdit(file)) {
                Mode mode = this.selectMode(file);
                if (mode == null) {
                    return null;
                }
                this.nextMode = mode;
            }
            try {
                Editor editor;
                editor = this.nextMode.createEditor(this, path, state);
                editor.setUpdatesAvailable(this.updatesAvailable);
                editor.getSketch().setUntitled(untitled);
                this.editors.add(editor);
                Recent.append(editor);
                editor.setVisible(true);
                return editor;
            }
            catch (EditorException ee) {
                if (ee.getMessage() != null) {
                    Messages.showWarning("Error opening sketch", ee.getMessage(), ee);
                }
            }
            catch (NoSuchMethodError nsme) {
                Messages.showWarning("Mode out of date", String.valueOf(this.nextMode.getTitle()) + " is not compatible with this version of Processing.\n" + "Try updating the Mode or contact its author for a new version.", nsme);
            }
            catch (Throwable t) {
                if (this.nextMode.equals(this.getDefaultMode())) {
                    Messages.showTrace("Serious Problem", "An unexpected, unknown, and unrecoverable error occurred\nwhile opening a new editor window. Please report this.", t, true);
                }
                Messages.showTrace("Mode Problems", "A nasty error occurred while trying to use " + this.nextMode.getTitle() + ".\n" + "It may not be compatible with this version of Processing.\n" + "Try updating the Mode or contact its author for a new version.", t, false);
            }
            if (!this.editors.isEmpty()) return null;
            Mode defaultMode = this.getDefaultMode();
            if (this.nextMode == defaultMode) {
                Messages.showError("Editor Problems", "An error occurred while trying to change modes.\nWe'll have to quit for now because it's an\nunfortunate bit of indigestion with the default Mode.", null);
                return null;
            }
            if (!untitled) return null;
            this.nextMode = defaultMode;
            this.handleNew();
            return null;
        }
        catch (Throwable t) {
            Messages.showTrace("Terrible News", "A serious error occurred while trying to create a new editor window.", t, this.nextMode == this.getDefaultMode());
            this.nextMode = this.getDefaultMode();
        }
        return null;
    }

    public boolean handleClose(Editor editor, boolean modeSwitch) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            Object[] options;
            String prompt;
            int result;
            if (Platform.isMacOS() && defaultFileMenu == null && ((result = JOptionPane.showOptionDialog(editor, prompt = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px; width: 300px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit Processing.", "Quit", 0, 3, null, options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")}, options[0])) == 1 || result == -1)) {
                return false;
            }
            Preferences.unset("server.port");
            Preferences.unset("server.key");
            Preferences.save();
            if (defaultFileMenu == null) {
                if (modeSwitch) {
                    editor.setVisible(false);
                    editor.dispose();
                    this.activeEditor = null;
                    this.editors.remove(editor);
                } else {
                    System.exit(0);
                }
            } else {
                editor.setVisible(false);
                editor.dispose();
                defaultFileMenu.insert(Recent.getMenu(), 2);
                this.activeEditor = null;
                this.editors.remove(editor);
            }
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            Console.shutdown();
            if (!Platform.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        for (Editor editor : this.editors) {
            if (editor.checkModified()) continue;
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenusAsync() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Base.this.rebuildSketchbookMenus();
            }
        });
    }

    public void thinkDifferentExamples() {
        this.nextMode.showExamplesFrame();
    }

    protected void rebuildSketchbookMenus() {
        for (Mode mode : this.getModeList()) {
            mode.rebuildImportMenu();
            mode.rebuildToolbarMenu();
            mode.rebuildExamplesFrame();
            mode.rebuildSketchbookFrame();
        }
    }

    protected void rebuildSketchbookMenu() {
        this.sketchbookMenu.removeAll();
        this.populateSketchbookMenu(this.sketchbookMenu);
    }

    public void populateSketchbookMenu(JMenu menu) {
        boolean found = false;
        try {
            found = this.addSketches(menu, sketchbookFolder, false);
        }
        catch (IOException e) {
            Messages.showWarning("Sketchbook Menu Error", "An error occurred while trying to list the sketchbook.", e);
        }
        if (!found) {
            JMenuItem empty = new JMenuItem(Language.text("menu.file.sketchbook.empty"));
            empty.setEnabled(false);
            menu.add(empty);
        }
    }

    protected boolean addSketches(JMenu menu, File folder, final boolean replaceExisting) throws IOException {
        String[] list;
        if (!folder.isDirectory()) {
            return false;
        }
        if (folder.getName().equals("libraries")) {
            return false;
        }
        if (folder.getName().equals("sdk")) {
            File suspectSDKPath = new File(folder.getParent(), folder.getName());
            File expectedSDKPath = new File(sketchbookFolder, "android" + File.separator + "sdk");
            if (expectedSDKPath.getAbsolutePath().equals(suspectSDKPath.getAbsolutePath())) {
                return false;
            }
        }
        if ((list = folder.list()) == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                if (new File(path).exists()) {
                    boolean replace = replaceExisting;
                    if ((e.getModifiers() & 1) != 0) {
                        replace = !replace;
                    }
                    Base.this.handleOpen(path);
                } else {
                    Messages.showWarning("Sketch Disappeared", "The selected sketch no longer exists.\nYou may need to restart Processing to update\nthe sketchbook menu.", null);
                }
            }
        };
        boolean found = false;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder;
            String name = stringArray[n2];
            if (name.charAt(0) != '.' && (subfolder = new File(folder, name)).isDirectory()) {
                File entry = this.checkSketchFolder(subfolder, name);
                if (entry != null) {
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(listener);
                    item.setActionCommand(entry.getAbsolutePath());
                    menu.add(item);
                    found = true;
                } else {
                    JMenu submenu = new JMenu(name);
                    boolean anything = this.addSketches(submenu, subfolder, replaceExisting);
                    if (anything && !name.equals("old")) {
                        menu.add(submenu);
                        found = true;
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    public boolean addSketches(DefaultMutableTreeNode node, File folder, boolean examples) throws IOException {
        if (!folder.isDirectory()) {
            return false;
        }
        String folderName = folder.getName();
        if (folderName.equals("libraries")) {
            return false;
        }
        if (!examples && folderName.equals("examples")) {
            return false;
        }
        String[] fileList = folder.list();
        if (fileList == null) {
            return false;
        }
        Arrays.sort(fileList, String.CASE_INSENSITIVE_ORDER);
        boolean found = false;
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File subfolder;
            String name = stringArray[n2];
            if (name.charAt(0) != '.' && (subfolder = new File(folder, name)).isDirectory()) {
                File entry = this.checkSketchFolder(subfolder, name);
                if (entry != null) {
                    DefaultMutableTreeNode item = new DefaultMutableTreeNode(new SketchReference(name, entry));
                    node.add(item);
                    found = true;
                } else {
                    DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(name);
                    boolean anything = this.addSketches(subnode, subfolder, examples);
                    if (anything) {
                        node.add(subnode);
                        found = true;
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    File checkSketchFolder(File subfolder, String item) {
        for (Mode mode : this.getModeList()) {
            File entry = new File(subfolder, String.valueOf(item) + "." + mode.getDefaultExtension());
            if (!entry.exists()) continue;
            return entry;
        }
        return null;
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new PreferencesFrame(this);
        }
        this.preferencesFrame.showFrame();
    }

    public static File getLibFile(String filename) throws IOException {
        return new File(Platform.getContentFile("lib"), filename);
    }

    public static InputStream getLibStream(String filename) throws IOException {
        return new FileInputStream(Base.getLibFile(filename));
    }

    public static File getSettingsFolder() {
        File settingsFolder = null;
        try {
            settingsFolder = Platform.getSettingsFolder();
            if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
                Messages.showError("Settings issues", "Processing cannot run because it could not\ncreate a folder to store your settings.\n" + settingsFolder.getAbsolutePath(), null);
            }
        }
        catch (Exception e) {
            Messages.showTrace("An rare and unknowable thing happened", "Could not get the settings folder. Please report:\nhttp://github.com/processing/processing/issues/new", e, true);
        }
        return settingsFolder;
    }

    public static File getSettingsFile(String filename) {
        return new File(Base.getSettingsFolder(), filename);
    }

    public static File getToolsFolder() {
        return Platform.getContentFile("tools");
    }

    public static void locateSketchbookFolder() {
        String sketchbookPath = Preferences.getSketchbookPath();
        if (sketchbookPath != null && !(sketchbookFolder = new File(sketchbookPath)).exists()) {
            Messages.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists.\nProcessing will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Processing will then stop talking\nabout itself in the third person.", null);
            sketchbookFolder = null;
        }
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.getDefaultSketchbookFolder();
            Preferences.setSketchbookPath(sketchbookFolder.getAbsolutePath());
            if (!sketchbookFolder.exists()) {
                sketchbookFolder.mkdirs();
            }
        }
        Base.makeSketchbookSubfolders();
    }

    public void setSketchbookFolder(File folder) {
        sketchbookFolder = folder;
        Preferences.setSketchbookPath(folder.getAbsolutePath());
        this.rebuildSketchbookMenus();
        Base.makeSketchbookSubfolders();
    }

    protected static void makeSketchbookSubfolders() {
        Base.getSketchbookLibrariesFolder().mkdirs();
        Base.getSketchbookToolsFolder().mkdirs();
        Base.getSketchbookModesFolder().mkdirs();
        Base.getSketchbookExamplesFolder().mkdirs();
        Base.getSketchbookTemplatesFolder().mkdirs();
    }

    public static File getSketchbookFolder() {
        return sketchbookFolder;
    }

    public static File getSketchbookLibrariesFolder() {
        return new File(sketchbookFolder, "libraries");
    }

    public static File getSketchbookToolsFolder() {
        return new File(sketchbookFolder, "tools");
    }

    public static File getSketchbookModesFolder() {
        return new File(sketchbookFolder, "modes");
    }

    public static File getSketchbookExamplesFolder() {
        return new File(sketchbookFolder, "examples");
    }

    public static File getSketchbookTemplatesFolder() {
        return new File(sketchbookFolder, "templates");
    }

    protected static File getDefaultSketchbookFolder() {
        File sketchbookFolder = null;
        try {
            sketchbookFolder = Platform.getDefaultSketchbookFolder();
        }
        catch (Exception exception) {}
        if (sketchbookFolder == null) {
            Messages.showError("No sketchbook", "Problem while trying to get the sketchbook", null);
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Messages.showError("You forgot your sketchbook", "Processing cannot run because it could not\ncreate a folder to store your sketchbook.", null);
        }
        return sketchbookFolder;
    }

    private static class ModeInfo {
        public final String title;
        public final String id;

        public ModeInfo(String id, String title) {
            this.id = id;
            this.title = title;
        }
    }
}

