/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.io.File;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericalSortFilenameComparator
implements Comparator<File> {
    public static Logger LOG = LoggerFactory.getLogger(NumericalSortFilenameComparator.class);
    private Pattern pattern = Pattern.compile("^(\\d*)(.*)$");
    private Function<File, BigInteger> leadingDigits = f -> {
        Matcher matcher;
        if (Objects.nonNull(f) && (matcher = this.pattern.matcher(f.getName().toLowerCase())).matches()) {
            return Optional.of(matcher.group(1)).filter(StringUtils::isNotEmpty).map(BigInteger::new).orElse(null);
        }
        return null;
    };

    @Override
    public int compare(File a, File b) {
        try {
            BigInteger bigA = this.leadingDigits.apply(a);
            BigInteger bigB = this.leadingDigits.apply(b);
            if (Objects.nonNull(bigA) && Objects.nonNull(bigB)) {
                return bigA.compareTo(bigB);
            }
        }
        catch (IllegalStateException | NumberFormatException e) {
            LOG.warn("Unexpected conversion issue", (Throwable)e);
        }
        return 0;
    }
}

