/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.ResettableView;
import org.pdfsam.ui.commons.SetDestinationRequest;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.DestinationPane;
import org.pdfsam.ui.io.PdfVersionCombo;
import org.pdfsam.ui.io.PdfVersionConstrainedCheckBox;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.support.Views;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.pdf.PdfVersion;

public class PdfDestinationPane
extends DestinationPane
implements ModuleOwned,
RestorableView,
ResettableView,
TaskParametersBuildStep<AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters>> {
    private PdfVersionCombo version;
    private PdfVersionConstrainedCheckBox compress;
    private Optional<CheckBox> discardBookmarks = Optional.empty();
    private String ownerModule = "";
    private UserContext userContext;

    public PdfDestinationPane(BrowsableField destination, String ownerModule, UserContext userContext, DestinationPanelFields ... optionalFields) {
        this(destination, ownerModule, userContext, false, optionalFields);
    }

    public PdfDestinationPane(BrowsableField destination, String ownerModule, UserContext userContext, boolean expandAdvanced, DestinationPanelFields ... optionalFields) {
        super(destination);
        destination.setId(ownerModule + ".destination");
        RequireUtils.requireNotNull((Object)userContext, (String)"UserContext cannot be null");
        this.userContext = userContext;
        this.ownerModule = StringUtils.defaultString((String)ownerModule);
        VBox advancedPanel = new VBox();
        advancedPanel.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.version = new PdfVersionCombo(ownerModule);
        this.compress = new PdfVersionConstrainedCheckBox(PdfVersion.VERSION_1_5, ownerModule);
        this.compress.setText(DefaultI18nContext.getInstance().i18n("Compress output file/files"));
        this.compress.setSelected(userContext.isCompressionEnabled());
        this.compress.setId("compressField");
        this.compress.getStyleClass().addAll((Object[])Style.VITEM.css());
        if (Arrays.asList(optionalFields).contains((Object)DestinationPanelFields.DISCARD_BOOKMARKS)) {
            CheckBox discardBookmarksField = new CheckBox(DefaultI18nContext.getInstance().i18n("Discard bookmarks"));
            discardBookmarksField.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Tick the box if you don't want to retain any bookmark from the original PDF document")));
            discardBookmarksField.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
            discardBookmarksField.getStyleClass().addAll((Object[])Style.VITEM.css());
            discardBookmarksField.setId("discardBookmarksField");
            this.discardBookmarks = Optional.of(discardBookmarksField);
        }
        HBox versionPane = new HBox(new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Output PDF version:")), this.version});
        versionPane.getStyleClass().addAll((Object[])Style.VITEM.css());
        versionPane.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        advancedPanel.getChildren().add((Object)this.compress);
        this.discardBookmarks.ifPresent(arg_0 -> advancedPanel.getChildren().add(arg_0));
        advancedPanel.getChildren().add((Object)versionPane);
        TitledPane titledAdvanced = Views.titledPane(DefaultI18nContext.getInstance().i18n("Show advanced settings"), (Node)advancedPanel);
        titledAdvanced.getStyleClass().add((Object)"advanced-destination-pane");
        titledAdvanced.setExpanded(expandAdvanced);
        titledAdvanced.expandedProperty().addListener((o, oldval, newVal) -> {
            if (newVal.booleanValue()) {
                titledAdvanced.setText(DefaultI18nContext.getInstance().i18n("Hide advanced settings"));
            } else {
                titledAdvanced.setText(DefaultI18nContext.getInstance().i18n("Show advanced settings"));
            }
        });
        this.getChildren().add((Object)titledAdvanced);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void enableSameAsSourceItem() {
        this.version.enableSameAsSourceItem();
    }

    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener
    public void setDestination(SetDestinationRequest event) {
        if (!event.isFallback() || StringUtils.isBlank((CharSequence)this.destination().getTextField().getText()) && this.userContext.isUseSmartOutput()) {
            this.destination().setTextFromFile(event.getFootprint());
        }
    }

    @Override
    public void resetView() {
        super.resetView();
        this.version.resetView();
        this.compress.setSelected(false);
        this.compress.setSelected(true);
        this.discardBookmarks.ifPresent(c -> c.setSelected(false));
    }

    public void apply(AbstractPdfOutputParametersBuilder<? extends AbstractPdfOutputParameters> builder, Consumer<String> onError) {
        builder.compress(this.compress.isSelected());
        if (this.overwrite().isSelected()) {
            builder.existingOutput(ExistingOutputPolicy.OVERWRITE);
        }
        builder.version(((PdfVersionCombo.PdfVersionComboItem)this.version.getSelectionModel().getSelectedItem()).getVersion());
        this.discardBookmarks.ifPresent(d -> builder.discardBookmarks(d.isSelected()));
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("compress", Boolean.toString(this.compress.isSelected()));
        data.put("overwrite", Boolean.toString(this.overwrite().isSelected()));
        this.discardBookmarks.ifPresent(d -> data.put("discardBookmarks", Boolean.toString(d.isSelected())));
        data.put("version", ((PdfVersionCombo.PdfVersionComboItem)this.version.getSelectionModel().getSelectedItem()).getVersion().toString());
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.version.resetView();
        this.compress.setSelected(Boolean.valueOf(data.get("compress")));
        this.overwrite().setSelected(Boolean.valueOf(data.get("overwrite")).booleanValue());
        this.discardBookmarks.ifPresent(d -> d.setSelected(Boolean.valueOf((String)data.get("discardBookmarks")).booleanValue()));
        Optional.ofNullable(data.get("version")).map(PdfVersion::valueOf).map(PdfVersionCombo.DefaultPdfVersionComboItem::new).ifPresent(v -> this.version.getSelectionModel().select(v));
    }

    PdfVersionCombo getVersion() {
        return this.version;
    }

    PdfVersionConstrainedCheckBox getCompress() {
        return this.compress;
    }

    public static enum DestinationPanelFields {
        DISCARD_BOOKMARKS;

    }
}

