/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.input.BaseCOSParser;

class ContentStreamCOSParser
extends BaseCOSParser {
    ContentStreamCOSParser(SeekableSource source) {
        super(source);
    }

    @Override
    public COSBase nextParsedToken() throws IOException {
        this.skipSpaces();
        char c = (char)this.source().peek();
        switch (c) {
            case '<': {
                this.source().read();
                c = (char)this.source().peek();
                this.source().back();
                if (c == '<') {
                    return this.nextDictionary();
                }
                return this.nextHexadecimalString();
            }
            case '[': {
                return this.nextArray();
            }
            case '(': {
                return this.nextLiteralString();
            }
            case '/': {
                return this.nextName();
            }
            case 'n': {
                String token = this.readToken();
                if ("null".equals(token)) {
                    return COSNull.NULL;
                }
                return null;
            }
            case 'f': 
            case 't': {
                String token = this.readToken();
                if ("true".equals(token)) {
                    return COSBoolean.TRUE;
                }
                if ("false".equals(token)) {
                    return COSBoolean.FALSE;
                }
                return null;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.nextNumber();
            }
            case '\uffff': {
                return null;
            }
        }
        String badString = this.readToken();
        if (badString.length() <= 0) {
            this.source().read();
        }
        return null;
    }
}

