/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.pdfsam.ui.notification.Notification;

public class NotificationsContainer
extends VBox {
    public NotificationsContainer() {
        this.getStyleClass().add((Object)"notifications");
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
    }

    void addNotification(String title, Node message) {
        Platform.runLater(() -> {
            Notification toAdd = this.doAddNotification(title, message);
            this.fadeIn(toAdd, (EventHandler<ActionEvent>)((EventHandler)e -> toAdd.fadeAway(Duration.seconds((double)5.0))));
        });
    }

    void addStickyNotification(String title, Node message) {
        Platform.runLater(() -> {
            Notification toAdd = this.doAddNotification(title, message);
            this.fadeIn(toAdd, null);
        });
    }

    private Notification doAddNotification(String title, Node message) {
        Notification toAdd = new Notification(title, message);
        toAdd.onFade((EventHandler<ActionEvent>)((EventHandler)e -> this.getChildren().remove((Object)toAdd)));
        this.getChildren().add((Object)toAdd);
        return toAdd;
    }

    private void fadeIn(Notification toAdd, EventHandler<ActionEvent> onFinished) {
        FadeTransition transition = new FadeTransition(Duration.millis((double)300.0), (Node)toAdd);
        transition.setFromValue(0.0);
        transition.setToValue(1.0);
        if (onFinished != null) {
            transition.setOnFinished(onFinished);
        }
        transition.play();
    }

    void removeNotification(String id) {
        Node toRemove = this.lookup(String.format("#%s", id));
        if (toRemove != null && toRemove instanceof Notification) {
            ((Notification)toRemove).fadeAway();
        }
    }
}

