# -*- coding: binary -*-

#
# This mixin implements an exploit's check method by invoking a scanner
#
# NOTE: The scanner's run_host method MUST return an Msf::Exploit::CheckCode
#

module Msf
module Exploit::Remote::CheckScanner

  def initialize(info = {})
    super

    register_advanced_options([
      OptString.new('CheckScanner', [true, 'Scanner to check with'])
    ])
  end

  # When this mixin is included, this method becomes the exploit's check method
  #
  # @return [Msf::Exploit::CheckCode] Whether or not the target is vulnerable
  def check
    # Instantiate the scanner
    mod = framework.modules.create(scanner)

    # Bail if we couldn't
    unless mod
      print_error("Could not instantiate #{scanner}")
      return CheckCode::Unsupported
    end

    # Bail if run_host isn't defined
    unless mod.respond_to?(:run_host)
      print_error("#{scanner} does not define a run_host method")
      return CheckCode::Unsupported
    end

    # Merge the exploit's datastore into the scanner's
    mod.datastore.merge!(datastore)

    # Use the exploit's input and output as the scanner's
    mod.user_input, mod.user_output = user_input, user_output

    # Use the scanner's CheckCode
    checkcode = mod.run_host(rhost)

    # Bail if scanner doesn't return a CheckCode
    unless checkcode.kind_of? Exploit::CheckCode
      print_error("#{scanner} does not return a CheckCode")
      return Exploit::CheckCode::Unsupported
    end

    # Return the CheckCode
    checkcode
  end

  def scanner
    datastore['CheckScanner']
  end

end
end
