/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class IncrementalAlterConfigsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<AlterConfigsResourceResult> responses;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new ArrayOf(AlterConfigsResourceResult.SCHEMA_0), "The responses for each resource."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public IncrementalAlterConfigsResponseData(Readable readable, short version) {
        this.responses = new ArrayList<AlterConfigsResourceResult>();
        this.read(readable, version);
    }

    public IncrementalAlterConfigsResponseData(Struct struct, short version) {
        this.responses = new ArrayList<AlterConfigsResourceResult>();
        this.fromStruct(struct, version);
    }

    public IncrementalAlterConfigsResponseData() {
        this.throttleTimeMs = 0;
        this.responses = new ArrayList<AlterConfigsResourceResult>();
    }

    @Override
    public short apiKey() {
        return 44;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.responses = null;
        } else {
            this.responses.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.responses.add(new AlterConfigsResourceResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.responses.size());
        for (AlterConfigsResourceResult element : this.responses) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("responses");
        this.responses = new ArrayList<AlterConfigsResourceResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.responses.add(new AlterConfigsResourceResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.responses.size()];
        int i = 0;
        for (AlterConfigsResourceResult element : this.responses) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("responses", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (AlterConfigsResourceResult element : this.responses) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IncrementalAlterConfigsResponseData)) {
            return false;
        }
        IncrementalAlterConfigsResponseData other = (IncrementalAlterConfigsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.responses == null ? other.responses != null : !this.responses.equals(other.responses));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        return hashCode;
    }

    public String toString() {
        return "IncrementalAlterConfigsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", responses=" + MessageUtil.deepToString(this.responses.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AlterConfigsResourceResult> responses() {
        return this.responses;
    }

    public IncrementalAlterConfigsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public IncrementalAlterConfigsResponseData setResponses(List<AlterConfigsResourceResult> v) {
        this.responses = v;
        return this;
    }

    public static class AlterConfigsResourceResult
    implements Message {
        private short errorCode;
        private String errorMessage;
        private byte resourceType;
        private String resourceName;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The resource error code."), new Field("error_message", Type.NULLABLE_STRING, "The resource error message, or null if there was no error."), new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public AlterConfigsResourceResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public AlterConfigsResourceResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AlterConfigsResourceResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.resourceType = 0;
            this.resourceName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
            this.resourceType = readable.readByte();
            this.resourceName = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
            writable.writeByte(this.resourceType);
            writable.writeString(this.resourceName);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            if (this.errorMessage != null) {
                size += MessageUtil.serializedUtf8Length(this.errorMessage);
            }
            ++size;
            size += 2;
            return size += MessageUtil.serializedUtf8Length(this.resourceName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterConfigsResourceResult)) {
                return false;
            }
            AlterConfigsResourceResult other = (AlterConfigsResourceResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.resourceType != other.resourceType) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterConfigsResourceResult(errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "', resourceType=" + this.resourceType + ", resourceName='" + this.resourceName + "')";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public AlterConfigsResourceResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public AlterConfigsResourceResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public AlterConfigsResourceResult setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public AlterConfigsResourceResult setResourceName(String v) {
            this.resourceName = v;
            return this;
        }
    }
}

