/**
 * @since 1.4.0
 */
export const booleanAlgebraBoolean = {
    meet: (x, y) => x && y,
    join: (x, y) => x || y,
    zero: false,
    one: true,
    implies: (x, y) => !x || y,
    not: x => !x
};
/**
 * @since 1.4.0
 */
export const booleanAlgebraVoid = {
    meet: () => undefined,
    join: () => undefined,
    zero: undefined,
    one: undefined,
    implies: () => undefined,
    not: () => undefined
};
/**
 * @since 1.4.0
 */
export const getFunctionBooleanAlgebra = (B) => () => {
    return {
        meet: (x, y) => a => B.meet(x(a), y(a)),
        join: (x, y) => a => B.join(x(a), y(a)),
        zero: () => B.zero,
        one: () => B.one,
        implies: (x, y) => a => B.implies(x(a), y(a)),
        not: x => a => B.not(x(a))
    };
};
/**
 * Every boolean algebras has a dual algebra, which involves reversing one/zero as well as join/meet.
 *
 * @since 1.4.0
 */
export const getDualBooleanAlgebra = (B) => {
    return {
        meet: (x, y) => B.join(x, y),
        join: (x, y) => B.meet(x, y),
        zero: B.one,
        one: B.zero,
        implies: (x, y) => B.join(B.not(x), y),
        not: B.not
    };
};
