'use strict';
var $ = require('../internals/export');
var IS_PURE = require('../internals/is-pure');
var anObject = require('../internals/an-object');
var getMapIterator = require('../internals/get-map-iterator');
var sameValueZero = require('../internals/same-value-zero');

// `Map.prototype.includes` method
// https://github.com/tc39/proposal-collection-methods
$({ target: 'Map', proto: true, real: true, forced: IS_PURE }, {
  includes: function includes(searchElement) {
    var map = anObject(this);
    var iterator = getMapIterator(map);
    var step;
    while (!(step = iterator.next()).done) {
      if (sameValueZero(step.value[1], searchElement)) return true;
    }
    return false;
  }
});
