/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.manager;

import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilderFactory;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RuntimeEnvironmentBuilder {
    public RuntimeEnvironmentBuilder persistence(boolean var1);

    public RuntimeEnvironmentBuilder entityManagerFactory(Object var1);

    public RuntimeEnvironmentBuilder addAsset(Resource var1, ResourceType var2);

    public RuntimeEnvironmentBuilder addEnvironmentEntry(String var1, Object var2);

    public RuntimeEnvironmentBuilder addConfiguration(String var1, String var2);

    public RuntimeEnvironmentBuilder knowledgeBase(KieBase var1);

    public RuntimeEnvironmentBuilder userGroupCallback(UserGroupCallback var1);

    public RuntimeEnvironmentBuilder userInfo(UserInfo var1);

    public RuntimeEnvironmentBuilder registerableItemsFactory(RegisterableItemsFactory var1);

    public RuntimeEnvironment get();

    public RuntimeEnvironmentBuilder classLoader(ClassLoader var1);

    public RuntimeEnvironmentBuilder schedulerService(Object var1);

    public static class Factory
    implements RuntimeEnvironmentBuilderFactory {
        private static RuntimeEnvironmentBuilderFactory INSTANCE;
        private static Logger logger;

        public static RuntimeEnvironmentBuilderFactory get() {
            if (INSTANCE == null) {
                throw new RuntimeException("RuntimeEnvironmentBuilder was not initialized, see previous errors");
            }
            return INSTANCE;
        }

        @Override
        public RuntimeEnvironmentBuilder newEmptyBuilder() {
            return Factory.get().newEmptyBuilder();
        }

        @Override
        public RuntimeEnvironmentBuilder newDefaultBuilder() {
            return Factory.get().newDefaultBuilder();
        }

        @Override
        public RuntimeEnvironmentBuilder newDefaultInMemoryBuilder() {
            return Factory.get().newDefaultInMemoryBuilder();
        }

        @Override
        public RuntimeEnvironmentBuilder newDefaultBuilder(String groupId, String artifactId, String version) {
            return Factory.get().newDefaultBuilder(groupId, artifactId, version);
        }

        @Override
        public RuntimeEnvironmentBuilder newDefaultBuilder(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
            return Factory.get().newDefaultBuilder(groupId, artifactId, version, kbaseName, ksessionName);
        }

        @Override
        public RuntimeEnvironmentBuilder newDefaultBuilder(ReleaseId releaseId) {
            return Factory.get().newDefaultBuilder(releaseId);
        }

        @Override
        public RuntimeEnvironmentBuilder newDefaultBuilder(ReleaseId releaseId, String kbaseName, String ksessionName) {
            return Factory.get().newDefaultBuilder(releaseId, kbaseName, ksessionName);
        }

        @Override
        public RuntimeEnvironmentBuilder newClasspathKmoduleDefaultBuilder() {
            return Factory.get().newClasspathKmoduleDefaultBuilder();
        }

        @Override
        public RuntimeEnvironmentBuilder newClasspathKmoduleDefaultBuilder(String kbaseName, String ksessionName) {
            return Factory.get().newClasspathKmoduleDefaultBuilder(kbaseName, ksessionName);
        }

        static {
            logger = LoggerFactory.getLogger(Factory.class);
            try {
                INSTANCE = (RuntimeEnvironmentBuilderFactory)Class.forName("org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder").newInstance();
            }
            catch (Exception e) {
                logger.error("Unable to instance RuntimeEnvironmentBuilderFactory due to " + e.getMessage());
            }
        }
    }
}

