/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.concurrent.TimeUnit;

interface ReconnectPolicy {
    public static final ReconnectPolicy CONNECT = new ReconnectPolicy(){

        @Override
        public void wait(int count) throws InterruptedException {
            int waitPeriod = count < 5 ? 1 : (count >= 5 && count < 10 ? 3 : (count >= 10 && count < 15 ? 10 : 20));
            TimeUnit.SECONDS.sleep(waitPeriod);
        }
    };
    public static final ReconnectPolicy RECONNECT = new ReconnectPolicy(){
        private static final int MAX_WAIT = 15;

        @Override
        public void wait(int count) throws InterruptedException {
            int waitPeriod = Math.min(count * count, 15);
            TimeUnit.SECONDS.sleep(waitPeriod);
        }
    };

    public void wait(int var1) throws InterruptedException;
}

