/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.PrimaryOwnerScheduler;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class InfinispanSessionManagerFactory<C extends Marshallability, L>
implements SessionManagerFactory<L, TransactionBatch> {
    final Batcher<TransactionBatch> batcher;
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final CacheProperties properties;
    final Cache<Key<String>, ?> cache;
    final org.wildfly.clustering.web.cache.session.Scheduler primaryOwnerScheduler;
    private final KeyAffinityServiceFactory affinityFactory;
    private final SessionFactory<CompositeSessionMetaDataEntry<L>, ?, L> factory;
    private final Scheduler expirationScheduler;
    private final SessionCreationMetaDataKeyFilter filter = new SessionCreationMetaDataKeyFilter();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(InfinispanSessionManagerFactory.createThreadFactory());
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();

    private static ThreadFactory createThreadFactory() {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(InfinispanSessionManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration<C, L> config) {
        this.affinityFactory = config.getKeyAffinityServiceFactory();
        this.cache = config.getCache();
        this.batcher = new InfinispanBatcher(this.cache);
        this.properties = config.getCacheProperties();
        InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(config);
        this.factory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getLocalContextFactory());
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.factory);
        this.expirationRegistrar = remover;
        this.expirationScheduler = new SessionExpirationScheduler(this.batcher, this.factory.getMetaDataFactory(), remover);
        CommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        PrimaryOwnerLocator primaryOwnerLocator = new PrimaryOwnerLocator(this.cache, config.getMemberFactory(), dispatcherFactory.getGroup());
        this.primaryOwnerScheduler = new PrimaryOwnerScheduler(dispatcherFactory, this.cache.getName(), this.expirationScheduler, (Function<Key<String>, Node>)primaryOwnerLocator);
        this.cache.addListener((Object)this);
        this.schedule((Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.cache));
    }

    public SessionManager<L, TransactionBatch> createSessionManager(final SessionManagerConfiguration configuration) {
        final AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(configuration.getIdentifierFactory(), this.cache, this.affinityFactory);
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Cache<Key<String>, ?> getCache() {
                return InfinispanSessionManagerFactory.this.cache;
            }

            @Override
            public CacheProperties getProperties() {
                return InfinispanSessionManagerFactory.this.properties;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return InfinispanSessionManagerFactory.this.batcher;
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistar() {
                return InfinispanSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return configuration.getInactiveSessionRecorder();
            }

            @Override
            public org.wildfly.clustering.web.cache.session.Scheduler getExpirationScheduler() {
                return InfinispanSessionManagerFactory.this.primaryOwnerScheduler;
            }
        };
        return new InfinispanSessionManager(this.factory, config);
    }

    private SessionAttributesFactory<?> createSessionAttributesFactory(InfinispanSessionManagerFactoryConfiguration<C, L> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.cache.removeListener((Object)this);
        PrivilegedAction<List> action = () -> this.executor.shutdownNow();
        WildFlySecurityManager.doUnchecked(action);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.primaryOwnerScheduler.close();
        this.expirationScheduler.close();
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<SessionCreationMetaDataKey, ?> event) {
        Cache cache = event.getCache();
        ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, event.getConsistentHashAtEnd());
        if (event.isPre()) {
            Future future = this.rehashFuture.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            try {
                this.executor.submit(() -> this.lambda$dataRehashed$2((Locality)newLocality));
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        } else {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, event.getConsistentHashAtStart());
            try {
                this.rehashFuture.set(this.executor.submit(() -> this.lambda$dataRehashed$3((Locality)oldLocality, (Locality)newLocality)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     */
    private void schedule(Locality oldLocality, Locality newLocality) {
        block32: {
            SessionMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
            CloseableIterator keys = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).keySet().iterator();
            Throwable throwable = null;
            while (true) {
                if (!keys.hasNext()) break block32;
                if (Thread.currentThread().isInterrupted()) {
                    break block32;
                }
                Key key = (Key)keys.next();
                if (!this.filter.test(key) || oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                String id = (String)key.getValue();
                Batch batch = this.batcher.createBatch();
                Throwable throwable2 = null;
                try {
                    CompositeSessionMetaDataEntry value = (CompositeSessionMetaDataEntry)metaDataFactory.tryValue((Object)id);
                    if (value != null) {
                        this.expirationScheduler.schedule(id, metaDataFactory.createImmutableSessionMetaData(id, (Object)value));
                    }
                    return;
                }
                catch (CacheException e) {
                    batch.discard();
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (batch == null) continue;
                    if (throwable2 != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    batch.close();
                    continue;
                }
                {
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
                break;
            }
            finally {
                if (keys != null) {
                    if (throwable != null) {
                        try {
                            keys.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        keys.close();
                    }
                }
            }
        }
    }

    private /* synthetic */ void lambda$dataRehashed$3(Locality oldLocality, Locality newLocality) {
        this.schedule(oldLocality, newLocality);
    }

    private /* synthetic */ void lambda$dataRehashed$2(Locality newLocality) {
        this.expirationScheduler.cancel(newLocality);
    }

    private static class InfinispanMarshalledValueSessionAttributesFactoryConfiguration<V, C extends Marshallability, L>
    extends MarshalledValueSessionAttributesFactoryConfiguration<V, C, L>
    implements InfinispanSessionAttributesFactoryConfiguration<V, MarshalledValue<V, C>> {
        private final InfinispanSessionManagerFactoryConfiguration<C, L> configuration;

        InfinispanMarshalledValueSessionAttributesFactoryConfiguration(InfinispanSessionManagerFactoryConfiguration<C, L> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        public <CK, CV> Cache<CK, CV> getCache() {
            return this.configuration.getCache();
        }
    }
}

