/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.federation.kerberos.KerberosConfig;
import org.keycloak.federation.kerberos.KerberosFederationProviderFactory;
import org.keycloak.federation.kerberos.ReadOnlyKerberosUserModelDelegate;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;

public class KerberosFederationProvider
implements UserStorageProvider,
UserLookupProvider,
CredentialInputValidator,
CredentialInputUpdater,
CredentialAuthentication,
ImportedUserValidation {
    private static final Logger logger = Logger.getLogger(KerberosFederationProvider.class);
    public static final String KERBEROS_PRINCIPAL = "KERBEROS_PRINCIPAL";
    protected KeycloakSession session;
    protected UserStorageProviderModel model;
    protected KerberosConfig kerberosConfig;
    protected KerberosFederationProviderFactory factory;

    public KerberosFederationProvider(KeycloakSession session, UserStorageProviderModel model, KerberosFederationProviderFactory factory) {
        this.session = session;
        this.model = model;
        this.kerberosConfig = new KerberosConfig((ComponentModel)model);
        this.factory = factory;
    }

    public UserModel validate(RealmModel realm, UserModel user) {
        if (!this.isValid(realm, user)) {
            return null;
        }
        if (this.kerberosConfig.getEditMode() == UserStorageProvider.EditMode.READ_ONLY) {
            return new ReadOnlyKerberosUserModelDelegate(user, this);
        }
        return user;
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
        if (authenticator.isUserAvailable(username)) {
            if (username.contains("@")) {
                username = username.split("@")[0];
            }
            return this.findOrCreateAuthenticatedUser(realm, username);
        }
        return null;
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return null;
    }

    public UserModel getUserById(String id, RealmModel realm) {
        return null;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean isValid(RealmModel realm, UserModel local) {
        String kerberosPrincipal = local.getUsername() + "@" + this.kerberosConfig.getKerberosRealm();
        return kerberosPrincipal.equalsIgnoreCase(local.getFirstAttribute(KERBEROS_PRINCIPAL));
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel) || !"password".equals(input.getType())) {
            return false;
        }
        if (this.kerberosConfig.getEditMode() == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Can't change password in Keycloak database. Change password with your Kerberos server");
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        return Collections.EMPTY_SET;
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals("kerberos") || this.kerberosConfig.isAllowPasswordAuthentication() && credentialType.equals("password");
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return "kerberos".equals(type);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.supportsCredentialType(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !this.session.userCredentialManager().isConfiguredLocally(realm, user, "password")) {
            return this.validPassword(user.getUsername(), input.getChallengeResponse());
        }
        return false;
    }

    protected boolean validPassword(String username, String password) {
        if (this.kerberosConfig.isAllowPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(username, password);
        }
        return false;
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return null;
        }
        UserCredentialModel credential = (UserCredentialModel)input;
        if (credential.getType().equals("kerberos")) {
            String spnegoToken = credential.getChallengeResponse();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
            return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
        }
        return null;
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userLocalStorage().getUserByUsername(username, realm);
        if (user != null) {
            user = this.session.users().getUserById(user.getId(), realm);
            logger.debug((Object)("Kerberos authenticated user " + username + " found in Keycloak storage"));
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warn((Object)("User with username " + username + " already exists, but is not linked to provider [" + this.model.getName() + "]"));
                return null;
            }
            UserModel proxied = this.validate(realm, user);
            if (proxied != null) {
                return proxied;
            }
            logger.warn((Object)("User with username " + username + " already exists and is linked to provider [" + this.model.getName() + "] but kerberos principal is not correct. Kerberos principal on user is: " + user.getFirstAttribute(KERBEROS_PRINCIPAL)));
            logger.warn((Object)"Will re-create user");
            new UserManager(this.session).removeUser(realm, user, this.session.userLocalStorage());
        }
        logger.debug((Object)("Kerberos authenticated user " + username + " not in Keycloak storage. Creating him"));
        return this.importUserToKeycloak(realm, username);
    }

    protected UserModel importUserToKeycloak(RealmModel realm, String username) {
        String email = username + "@" + this.kerberosConfig.getKerberosRealm().toLowerCase();
        logger.debugf("Creating kerberos user: %s, email: %s to local Keycloak storage", (Object)username, (Object)email);
        UserModel user = this.session.userLocalStorage().addUser(realm, username);
        user.setEnabled(true);
        user.setEmail(email);
        user.setFederationLink(this.model.getId());
        user.setSingleAttribute(KERBEROS_PRINCIPAL, username + "@" + this.kerberosConfig.getKerberosRealm());
        if (this.kerberosConfig.isUpdateProfileFirstLogin()) {
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
        }
        return this.validate(realm, user);
    }
}

