/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.opentracing.Tracer;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.wildfly.microprofile.opentracing.smallrye.TracerProducer;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;

public class TracingCDIExtension
implements Extension {
    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        String extensionName = TracingCDIExtension.class.getName();
        bbd.addAnnotatedType(manager.createAnnotatedType(TracerProducer.class), extensionName + "-" + TracerProducer.class.getName());
    }

    public void skipTracerBeans(@Observes ProcessAnnotatedType<? extends Tracer> processAnnotatedType) {
        TracingLogger.ROOT_LOGGER.extraTracerBean(processAnnotatedType.getAnnotatedType().getJavaClass().getName());
        processAnnotatedType.veto();
    }
}

