/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.store.ldap;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.LDAPConstants;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.vault.VaultCharSecret;

public final class LDAPContextManager
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LDAPContextManager.class);
    private final KeycloakSession session;
    private final LDAPConfig ldapConfig;
    private StartTlsResponse tlsResponse;
    private VaultCharSecret vaultCharSecret = new VaultCharSecret(){

        public Optional<CharBuffer> get() {
            return Optional.empty();
        }

        public Optional<char[]> getAsArray() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private LdapContext ldapContext;

    public LDAPContextManager(KeycloakSession session, LDAPConfig connectionProperties) {
        this.session = session;
        this.ldapConfig = connectionProperties;
    }

    public static LDAPContextManager create(KeycloakSession session, LDAPConfig connectionProperties) {
        return new LDAPContextManager(session, connectionProperties);
    }

    private void createLdapContext() throws NamingException {
        Hashtable<Object, Object> connProp = LDAPContextManager.getConnectionProperties(this.ldapConfig);
        if (!"none".equals(this.ldapConfig.getAuthType())) {
            this.vaultCharSecret = this.getVaultSecret();
            if (this.vaultCharSecret != null && !this.ldapConfig.isStartTls()) {
                connProp.put("java.naming.security.credentials", this.vaultCharSecret.getAsArray().orElse(this.ldapConfig.getBindCredential().toCharArray()));
            }
        }
        this.ldapContext = new InitialLdapContext(connProp, null);
        if (this.ldapConfig.isStartTls()) {
            this.tlsResponse = LDAPContextManager.startTLS(this.ldapContext, this.ldapConfig.getAuthType(), this.ldapConfig.getBindDN(), this.vaultCharSecret.getAsArray().orElse(this.ldapConfig.getBindCredential().toCharArray()));
        }
    }

    public LdapContext getLdapContext() throws NamingException {
        if (this.ldapContext == null) {
            this.createLdapContext();
        }
        return this.ldapContext;
    }

    private VaultCharSecret getVaultSecret() {
        return "none".equals(this.ldapConfig.getAuthType()) ? null : this.session.vault().getCharSecret(this.ldapConfig.getBindCredential());
    }

    public static StartTlsResponse startTLS(LdapContext ldapContext, String authType, String bindDN, char[] bindCredential) throws NamingException {
        try {
            StartTlsResponse tls = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
            tls.negotiate();
            ldapContext.addToEnvironment("java.naming.security.authentication", authType);
            if (!"none".equals(authType)) {
                ldapContext.addToEnvironment("java.naming.security.principal", bindDN);
                ldapContext.addToEnvironment("java.naming.security.credentials", bindCredential);
            }
            ldapContext.lookup("");
            return tls;
        }
        catch (Exception e) {
            logger.error((Object)"Could not negotiate TLS", (Throwable)e);
            return null;
        }
    }

    public static Hashtable<Object, Object> getConnectionProperties(LDAPConfig ldapConfig) {
        Properties additionalProperties;
        String readTimeout;
        String connectionTimeout;
        String url;
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("java.naming.factory.initial", ldapConfig.getFactoryName());
        if (!ldapConfig.isStartTls()) {
            String authType = ldapConfig.getAuthType();
            env.put("java.naming.security.authentication", authType);
            String bindDN = ldapConfig.getBindDN();
            char[] bindCredential = null;
            if (ldapConfig.getBindCredential() != null) {
                bindCredential = ldapConfig.getBindCredential().toCharArray();
            }
            if (!"none".equals(authType)) {
                env.put("java.naming.security.principal", bindDN);
                env.put("java.naming.security.credentials", bindCredential);
            }
        }
        if ((url = ldapConfig.getConnectionUrl()) != null) {
            env.put("java.naming.provider.url", url);
        } else {
            logger.warn((Object)"LDAP URL is null. LDAPOperationManager won't work correctly");
        }
        String useTruststoreSpi = ldapConfig.getUseTruststoreSpi();
        LDAPConstants.setTruststoreSpiIfNeeded((String)useTruststoreSpi, (String)url, env);
        String connectionPooling = ldapConfig.getConnectionPooling();
        if (connectionPooling != null) {
            env.put("com.sun.jndi.ldap.connect.pool", connectionPooling);
        }
        if ((connectionTimeout = ldapConfig.getConnectionTimeout()) != null && !connectionTimeout.isEmpty()) {
            env.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
        }
        if ((readTimeout = ldapConfig.getReadTimeout()) != null && !readTimeout.isEmpty()) {
            env.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        }
        if ((additionalProperties = ldapConfig.getAdditionalConnectionProperties()) != null) {
            for (Object object : additionalProperties.keySet()) {
                env.put(object.toString(), additionalProperties.getProperty(object.toString()));
            }
        }
        StringBuilder binaryAttrsBuilder = new StringBuilder();
        if (ldapConfig.isObjectGUID()) {
            binaryAttrsBuilder.append("objectGUID").append(" ");
        }
        if (ldapConfig.isEdirectory()) {
            binaryAttrsBuilder.append("guid").append(" ");
        }
        for (String attrName : ldapConfig.getBinaryAttributeNames()) {
            binaryAttrsBuilder.append(attrName).append(" ");
        }
        String string = binaryAttrsBuilder.toString().trim();
        if (!string.isEmpty()) {
            env.put("java.naming.ldap.attributes.binary", string);
        }
        if (logger.isDebugEnabled()) {
            HashMap<String, String> copyEnv = new HashMap<String, String>(env);
            if (copyEnv.containsKey("java.naming.security.credentials")) {
                copyEnv.put("java.naming.security.credentials", "**************************************");
            }
            logger.debugf("Creating LdapContext using properties: [%s]", copyEnv);
        }
        return new Hashtable<Object, Object>(env);
    }

    @Override
    public void close() {
        if (this.vaultCharSecret != null) {
            this.vaultCharSecret.close();
        }
        if (this.tlsResponse != null) {
            try {
                this.tlsResponse.close();
            }
            catch (IOException e) {
                logger.error((Object)"Could not close Ldap tlsResponse.", (Throwable)e);
            }
        }
        if (this.ldapContext != null) {
            try {
                this.ldapContext.close();
            }
            catch (NamingException e) {
                logger.error((Object)"Could not close Ldap context.", (Throwable)e);
            }
        }
    }
}

