/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.math.ec.rfc8032.Ed448;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsEd448Signer
extends BcTlsSigner {
    protected final Ed448PublicKeyParameters publicKey;

    public BcTlsEd448Signer(BcTlsCrypto bcTlsCrypto, Ed448PrivateKeyParameters ed448PrivateKeyParameters, Ed448PublicKeyParameters ed448PublicKeyParameters) {
        super(bcTlsCrypto, (AsymmetricKeyParameter)ed448PrivateKeyParameters);
        this.publicKey = ed448PublicKeyParameters != null ? ed448PublicKeyParameters : ed448PrivateKeyParameters.generatePublicKey();
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != 8 || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return new TlsStreamSigner(){

            public OutputStream getOutputStream() {
                return byteArrayOutputStream;
            }

            public byte[] getSignature() throws IOException {
                byte[] byArray = new byte[57];
                ((Ed448PrivateKeyParameters)BcTlsEd448Signer.this.privateKey).encode(byArray, 0);
                byte[] byArray2 = BcTlsEd448Signer.this.publicKey.getEncoded();
                byte[] byArray3 = TlsUtils.EMPTY_BYTES;
                byte[] byArray4 = byteArrayOutputStream.toByteArray();
                byte[] byArray5 = new byte[114];
                Ed448.sign((byte[])byArray, (int)0, (byte[])byArray2, (int)0, (byte[])byArray3, (byte[])byArray4, (int)0, (int)byArray4.length, (byte[])byArray5, (int)0);
                Arrays.fill(byArray, (byte)0);
                return byArray5;
            }
        };
    }
}

